/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.server;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.shedaniel.rei.server.ContainerContext;
import me.shedaniel.rei.server.ContainerInfo;
import me.shedaniel.rei.server.ContainerInfoHandler;
import me.shedaniel.rei.server.RecipeFinder;
import me.shedaniel.rei.server.RecipeGridAligner;
import me.shedaniel.rei.server.StackAccessor;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class InputSlotCrafter<C extends class_1263>
implements RecipeGridAligner<Integer>,
ContainerContext {
    protected class_1703 container;
    protected ContainerInfo containerInfo;
    private List<StackAccessor> gridStacks;
    private List<StackAccessor> inventoryStacks;
    private class_3222 player;

    private InputSlotCrafter(class_1703 container, ContainerInfo<? extends class_1703> containerInfo) {
        this.container = container;
        this.containerInfo = containerInfo;
    }

    public static <C extends class_1263> void start(class_2960 category, class_1703 craftingContainer_1, class_3222 player, Map<Integer, List<class_1799>> map, boolean hasShift) {
        ContainerInfo containerInfo = Objects.requireNonNull(ContainerInfoHandler.getContainerInfo((class_2960)category, craftingContainer_1.getClass()), "Container Info does not exist on the server!");
        super.fillInputSlots(player, map, hasShift);
    }

    private void fillInputSlots(class_3222 player, Map<Integer, List<class_1799>> map, boolean hasShift) {
        this.player = player;
        this.inventoryStacks = this.containerInfo.getInventoryStacks((ContainerContext)this);
        this.gridStacks = this.containerInfo.getGridStacks((ContainerContext)this);
        player.field_13991 = true;
        this.returnInputs();
        RecipeFinder recipeFinder = new RecipeFinder();
        this.containerInfo.getRecipeFinderPopulator().populate((ContainerContext)this).accept(recipeFinder);
        class_2371 ingredients = class_2371.method_10211();
        map.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).forEach(entry -> ingredients.add((Object)class_1856.method_8091((class_1935[])((class_1935[])((List)entry.getValue()).stream().map(class_1799::method_7909).toArray(class_1792[]::new)))));
        if (!recipeFinder.findRecipe(ingredients, null)) {
            this.returnInputs();
            player.field_13991 = false;
            this.containerInfo.markDirty((ContainerContext)this);
            throw new NotEnoughMaterialsException();
        }
        this.fillInputSlots(recipeFinder, (class_2371<class_1856>)ingredients, hasShift);
        player.field_13991 = false;
        this.containerInfo.markDirty((ContainerContext)this);
    }

    public void acceptAlignedInput(Iterator<Integer> iterator_1, StackAccessor gridSlot, int craftsAmount) {
        class_1799 toBeTakenStack = RecipeFinder.getStackFromId((int)iterator_1.next());
        if (!toBeTakenStack.method_7960()) {
            for (int i = 0; i < craftsAmount; ++i) {
                this.fillInputSlot(gridSlot, toBeTakenStack);
            }
        }
    }

    protected void fillInputSlot(StackAccessor slot, class_1799 toBeTakenStack) {
        class_1799 takenStack;
        int takenSlotIndex = this.method_7371(toBeTakenStack);
        if (takenSlotIndex != -1 && !(takenStack = this.inventoryStacks.get(takenSlotIndex).getItemStack().method_7972()).method_7960()) {
            if (takenStack.method_7947() > 1) {
                this.inventoryStacks.get(takenSlotIndex).takeStack(1);
            } else {
                this.inventoryStacks.get(takenSlotIndex).setItemStack(class_1799.field_8037);
            }
            takenStack.method_7939(1);
            if (slot.getItemStack().method_7960()) {
                slot.setItemStack(takenStack);
            } else {
                slot.getItemStack().method_7933(1);
            }
        }
    }

    protected void fillInputSlots(RecipeFinder recipeFinder, class_2371<class_1856> ingredients, boolean hasShift) {
        IntArrayList intList_1 = new IntArrayList();
        int recipeCrafts = recipeFinder.countRecipeCrafts(ingredients, null);
        int amountToFill = this.getAmountToFill(hasShift, recipeCrafts, false);
        if (recipeFinder.findRecipe(ingredients, (IntList)intList_1, amountToFill)) {
            int finalCraftsAmount = amountToFill;
            IntListIterator intListIterator = intList_1.iterator();
            while (intListIterator.hasNext()) {
                int itemId = (Integer)intListIterator.next();
                finalCraftsAmount = Math.min(finalCraftsAmount, RecipeFinder.getStackFromId((int)itemId).method_7914());
            }
            if (recipeFinder.findRecipe(ingredients, (IntList)intList_1, finalCraftsAmount)) {
                this.returnInputs();
                this.alignRecipeToGrid(this.gridStacks, (Iterator)intList_1.iterator(), finalCraftsAmount);
            }
        }
    }

    protected int getAmountToFill(boolean hasShift, int recipeCrafts, boolean boolean_2) {
        int amountToFill = 1;
        if (hasShift) {
            amountToFill = recipeCrafts;
        } else if (boolean_2) {
            amountToFill = 64;
            for (StackAccessor stackAccessor : this.gridStacks) {
                class_1799 itemStack = stackAccessor.getItemStack();
                if (itemStack.method_7960() || amountToFill <= itemStack.method_7947()) continue;
                amountToFill = itemStack.method_7947();
            }
            if (amountToFill < 64) {
                ++amountToFill;
            }
        }
        return amountToFill;
    }

    protected void returnInputs() {
        this.containerInfo.getGridCleanHandler().clean((ContainerContext)this);
    }

    public int method_7371(class_1799 itemStack) {
        for (int i = 0; i < this.inventoryStacks.size(); ++i) {
            class_1799 itemStack1 = this.inventoryStacks.get(i).getItemStack();
            if (itemStack1.method_7960() || !InputSlotCrafter.areItemsEqual(itemStack, itemStack1) || itemStack1.method_7986() || itemStack1.method_7942() || itemStack1.method_7938()) continue;
            return i;
        }
        return -1;
    }

    private static boolean areItemsEqual(class_1799 stack1, class_1799 stack2) {
        return stack1.method_7909() == stack2.method_7909() && class_1799.method_7975((class_1799)stack1, (class_1799)stack2);
    }

    private int getFreeInventorySlots() {
        int int_1 = 0;
        for (StackAccessor inventoryStack : this.inventoryStacks) {
            if (!inventoryStack.getItemStack().method_7960()) continue;
            ++int_1;
        }
        return int_1;
    }

    public class_1703 getContainer() {
        return this.container;
    }

    public class_1657 getPlayerEntity() {
        return this.player;
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public static class NotEnoughMaterialsException
    extends RuntimeException {
    }
}

