/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import me.shedaniel.rei.api.PluginDisabler;
import me.shedaniel.rei.api.PluginFunction;
import net.minecraft.class_2960;
import java.util.List;
import java.util.Map;

public class PluginDisablerImpl implements PluginDisabler {
    
    private static Map<class_2960, List<PluginFunction>> pluginDisabledFunctions = Maps.newHashMap();
    
    @Override
    public void disablePluginFunction(class_2960 plugin, PluginFunction function) {
        List<PluginFunction> list = Lists.newArrayList();
        if (pluginDisabledFunctions.containsKey(plugin))
            list = pluginDisabledFunctions.get(plugin);
        if (!list.contains(function))
            list.add(function);
        pluginDisabledFunctions.put(plugin, list);
    }
    
    @Override
    public void enablePluginFunction(class_2960 plugin, PluginFunction function) {
        List<PluginFunction> list = Lists.newArrayList();
        if (pluginDisabledFunctions.containsKey(plugin))
            list = pluginDisabledFunctions.get(plugin);
        if (list.contains(function))
            list.remove(function);
        pluginDisabledFunctions.put(plugin, list);
        if (list.size() == 0)
            pluginDisabledFunctions.remove(plugin);
    }
    
    @Override
    public boolean isFunctionEnabled(class_2960 plugin, PluginFunction function) {
        return !pluginDisabledFunctions.containsKey(plugin) || !pluginDisabledFunctions.get(plugin).contains(function);
    }
    
}
