/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.class_1109;
import net.minecraft.class_308;
import net.minecraft.class_3417;

public class SearchFieldWidget extends TextFieldWidget {
    
    public static boolean isSearching = false;
    protected long lastClickedTime = -1;
    
    public SearchFieldWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
    }
    
    public void laterRender(int int_1, int int_2, float float_1) {
        class_308.method_1450();
        GlStateManager.disableDepthTest();
        setEditableColor(isSearching ? -1313241 : 14737632);
        super.render(int_1, int_2, float_1);
        GlStateManager.enableDepthTest();
    }
    
    @Override
    public void renderBorder() {
        if (!isSearching)
            super.renderBorder();
        else {
            fill(this.getBounds().x - 1, this.getBounds().y - 1, this.getBounds().x + this.getBounds().width + 1, this.getBounds().y + this.getBounds().height + 1, -1313241);
            fill(this.getBounds().x, this.getBounds().y, this.getBounds().x + this.getBounds().width, this.getBounds().y + this.getBounds().height, -16777216);
        }
    }
    
    @Override
    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        boolean contains = isHighlighted(double_1, double_2);
        if (isVisible() && contains && int_1 == 1)
            setText("");
        if (contains && int_1 == 0)
            if (lastClickedTime == -1)
                lastClickedTime = System.currentTimeMillis();
            else if (System.currentTimeMillis() - lastClickedTime > 1200)
                lastClickedTime = -1;
            else {
                lastClickedTime = -1;
                isSearching = !isSearching;
                minecraft.method_1483().method_4873(class_1109.method_4758(class_3417.field_15015, 1.0F));
            }
        return super.mouseClicked(double_1, double_2, int_1);
    }
    
    @Override
    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (this.isVisible() && this.isFocused())
            if (int_1 == 257 || int_1 == 335) {
                setFocused(false);
                return true;
            }
        return super.keyPressed(int_1, int_2, int_3);
    }
    
    @Override
    public void render(int int_1, int int_2, float float_1) {
    }
    
}
