/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin;

import com.mojang.blaze3d.platform.GlStateManager;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.Renderable;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import me.shedaniel.rei.gui.widget.SlotWidget;
import me.shedaniel.rei.gui.widget.Widget;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import java.awt.*;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;

public class DefaultCampfireCategory implements RecipeCategory<DefaultCampfireDisplay> {
    
    private static final class_2960 DISPLAY_TEXTURE = new class_2960("roughlyenoughitems", "textures/gui/display.png");
    
    @Override
    public class_2960 getIdentifier() {
        return DefaultPlugin.CAMPFIRE;
    }
    
    @Override
    public Renderer getIcon() {
        return Renderable.fromItemStack(new class_1799(class_2246.field_17350));
    }
    
    @Override
    public String getCategoryName() {
        return class_1074.method_4662("category.rei.campfire");
    }
    
    @Override
    public List<Widget> setupDisplay(Supplier<DefaultCampfireDisplay> recipeDisplaySupplier, Rectangle bounds) {
        Point startPoint = new Point((int) bounds.getCenterX() - 41, (int) bounds.getCenterY() - 27);
        List<Widget> widgets = new LinkedList<>(Arrays.asList(new RecipeBaseWidget(bounds) {
            @Override
            public void render(int mouseX, int mouseY, float delta) {
                super.render(mouseX, mouseY, delta);
                GlStateManager.color4f(1.0F, 1.0F, 1.0F, 1.0F);
                class_308.method_1450();
                class_310.method_1551().method_1531().method_4618(DISPLAY_TEXTURE);
                blit(startPoint.x, startPoint.y, 0, 167, 82, 54);
                int height = class_3532.method_15384((System.currentTimeMillis() / 250 % 14d) / 1f);
                blit(startPoint.x + 2, startPoint.y + 31 + (14 - height), 82, 77 + (14 - height), 14, height);
                int width = class_3532.method_15384((System.currentTimeMillis() / 250 % 24d) / 1f);
                blit(startPoint.x + 24, startPoint.y + 18, 82, 91, width, 17);
                String text = class_1074.method_4662("category.rei.campfire.time", class_3532.method_15357(recipeDisplaySupplier.get().getCookTime() / 20d));
                int length = class_310.method_1551().field_1772.method_1727(text);
                class_310.method_1551().field_1772.method_1729(text, bounds.x + bounds.width - length - 5, startPoint.y + 54 - 8, 4210752);
            }
        }));
        widgets.add(new SlotWidget(startPoint.x + 1, startPoint.y + 11, recipeDisplaySupplier.get().getInput().get(0), true, true, true));
        widgets.add(new SlotWidget(startPoint.x + 61, startPoint.y + 19, recipeDisplaySupplier.get().getOutput(), false, true, true));
        return widgets;
    }
    
}
