/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin;

import com.google.common.collect.Lists;
import me.shedaniel.rei.api.RecipeDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3920;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DefaultCampfireDisplay implements RecipeDisplay<class_3920> {
    
    private List<class_1799> inputs, output;
    private int cookTime;
    private class_3920 display;
    
    public DefaultCampfireDisplay(class_3920 recipe) {
        this(recipe.method_8117(), recipe.method_8110(), recipe.method_8167());
        this.display = recipe;
    }
    
    public DefaultCampfireDisplay(class_2371<class_1856> ingredients, class_1799 output, int cookTime) {
        this.inputs = Lists.newArrayList();
        ingredients.stream().map(ingredient -> Lists.newArrayList(ingredient.method_8105())).forEach(inputs::addAll);
        this.output = Collections.singletonList(output);
        this.cookTime = cookTime;
    }
    
    public int getCookTime() {
        return cookTime;
    }
    
    @Override
    public Optional<class_3920> getRecipe() {
        return Optional.ofNullable(display);
    }
    
    @Override
    public List<List<class_1799>> getInput() {
        return Collections.singletonList(inputs);
    }
    
    @Override
    public List<class_1799> getOutput() {
        return this.output;
    }
    
    @Override
    public class_2960 getRecipeCategory() {
        return DefaultPlugin.CAMPFIRE;
    }
    
    @Override
    public List<List<class_1799>> getRequiredItems() {
        return getInput();
    }
    
}
