/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1860;

public class DefaultCustomDisplay implements DefaultCraftingDisplay {
    
    private List<List<class_1799>> input;
    private List<class_1799> output;
    private class_1860 possibleRecipe;
    private int width, height;
    
    public DefaultCustomDisplay(List<List<class_1799>> input, List<class_1799> output, class_1860 possibleRecipe) {
        this.input = input;
        this.output = output;
        this.possibleRecipe = possibleRecipe;
        List<Boolean> row = Lists.newArrayList(false, false, false);
        List<Boolean> column = Lists.newArrayList(false, false, false);
        for(int i = 0; i < 9; i++)
            if (i < input.size()) {
                List<class_1799> stacks = input.get(i);
                if (stacks.stream().filter(stack -> !stack.method_7960()).count() > 0) {
                    row.set((i - (i % 3)) / 3, true);
                    column.set(i % 3, true);
                }
            }
        width = (int) column.stream().filter(b -> b).count();
        height = (int) row.stream().filter(b -> b).count();
    }
    
    public DefaultCustomDisplay(List<List<class_1799>> input, List<class_1799> output) {
        this(input, output, null);
    }
    
    @Override
    public Optional<class_1860> getRecipe() {
        return Optional.ofNullable(possibleRecipe);
    }
    
    @Override
    public List<List<class_1799>> getInput() {
        return Collections.unmodifiableList(input);
    }
    
    @Override
    public List<class_1799> getOutput() {
        return Collections.unmodifiableList(output);
    }
    
    @Override
    public List<List<class_1799>> getRequiredItems() {
        return Collections.unmodifiableList(input);
    }
    
    @Override
    public int getWidth() {
        return width;
    }
    
    @Override
    public int getHeight() {
        return height;
    }
    
}
