/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1867;

public class DefaultShapelessDisplay implements DefaultCraftingDisplay {
    
    private class_1867 display;
    private List<List<class_1799>> input;
    private List<class_1799> output;
    
    public DefaultShapelessDisplay(class_1867 recipe) {
        this.display = recipe;
        this.input = Lists.newArrayList(recipe.method_8117().stream().map(i -> Lists.newArrayList(i.method_8105())).collect(Collectors.toList()));
        this.output = Collections.singletonList(recipe.method_8110());
    }
    
    @Override
    public Optional<class_1867> getRecipe() {
        return Optional.ofNullable(display);
    }
    
    @Override
    public List<List<class_1799>> getInput() {
        return input;
    }
    
    @Override
    public List<class_1799> getOutput() {
        return output;
    }
    
    @Override
    public List<List<class_1799>> getRequiredItems() {
        return input;
    }
    
    @Override
    public int getWidth() {
        if (display.method_8117().size() > 4)
            return 3;
        return 2;
    }
    
    @Override
    public int getHeight() {
        if (display.method_8117().size() > 4)
            return 3;
        return 2;
    }
    
}
