/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin;

import com.google.common.collect.Lists;
import me.shedaniel.rei.api.RecipeDisplay;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3862;
import net.minecraft.class_3866;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DefaultSmokingDisplay implements RecipeDisplay<class_3862> {
    
    private class_3862 display;
    private List<List<class_1799>> input;
    private List<class_1799> output;
    
    public DefaultSmokingDisplay(class_3862 recipe) {
        this.display = recipe;
        this.input = Lists.newArrayList(recipe.method_8117().stream().map(i -> Lists.newArrayList(i.method_8105())).collect(Collectors.toList()));
        input.add(class_3866.method_11196().keySet().stream().map(class_1792::method_7854).collect(Collectors.toList()));
        this.output = Collections.singletonList(recipe.method_8110());
    }
    
    @Override
    public Optional<class_3862> getRecipe() {
        return Optional.ofNullable(display);
    }
    
    @Override
    public List<List<class_1799>> getInput() {
        return input;
    }
    
    public List<class_1799> getFuel() {
        return input.get(1);
    }
    
    @Override
    public List<class_1799> getOutput() {
        return output;
    }
    
    @Override
    public class_2960 getRecipeCategory() {
        return DefaultPlugin.SMOKING;
    }
    
    @Override
    public List<List<class_1799>> getRequiredItems() {
        return input;
    }
    
}
