/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import java.util.function.Function;
import java.util.regex.Pattern;

public class SearchArgument {
    public static final Function<Integer, Boolean> INCLUDE = integer -> integer > -1;
    public static final Function<Integer, Boolean> NOT_INCLUDE = integer -> integer <= -1;
    private ArgumentType argumentType;
    private String text;
    private boolean include;
    private Pattern pattern;
    public static final SearchArgument ALWAYS = new SearchArgument(ArgumentType.ALWAYS, "", true);

    public SearchArgument(ArgumentType argumentType, String text, boolean include) {
        this(argumentType, text, include, true);
    }

    public SearchArgument(ArgumentType argumentType, String text, boolean include, boolean autoLowerCase) {
        this.argumentType = argumentType;
        this.text = autoLowerCase ? text.toLowerCase() : text;
        this.include = include;
    }

    public static Function<Integer, Boolean> getFunction(boolean include) {
        return include ? INCLUDE : NOT_INCLUDE;
    }

    public ArgumentType getArgumentType() {
        return this.argumentType;
    }

    public String getText() {
        return this.text;
    }

    public boolean isInclude() {
        return this.include;
    }

    public String toString() {
        return String.format("Argument[%s]: name = %s, include = %b", this.argumentType.name(), this.text, this.include);
    }

    public static enum ArgumentType {
        TEXT,
        MOD,
        TOOLTIP,
        ALWAYS;

    }
}

