/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import java.awt.Color;
import java.awt.Point;
import java.util.Optional;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.widget.LabelWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;

public abstract class ClickableLabelWidget
extends LabelWidget {
    public static final int hoveredColor = new Color(102, 255, 204).getRGB();
    public boolean focused;
    public boolean clickable;

    public ClickableLabelWidget(int x, int y, String text, boolean clickable) {
        super(x, y, text);
        this.clickable = clickable;
    }

    public ClickableLabelWidget(int x, int y, String text) {
        this(x, y, text, true);
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        int colour = this.getDefaultColor();
        if (this.clickable && this.isHovered(mouseX, mouseY)) {
            colour = this.getHoveredColor();
        }
        this.drawCenteredString(this.font, (this.isHovered(mouseX, mouseY) ? "\ufffd\ufffdn" : "") + this.text, this.x, this.y, colour);
        if (this.clickable && this.getTooltips().isPresent()) {
            if (!this.focused && this.isHighlighted(mouseX, mouseY)) {
                ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(this.getTooltips().get().split("\n")));
            } else if (this.focused) {
                ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(new Point(this.x, this.y), this.getTooltips().get().split("\n")));
            }
        }
    }

    public int getDefaultColor() {
        return -1;
    }

    public int getHoveredColor() {
        return hoveredColor;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.clickable && this.isHighlighted(mouseX, mouseY)) {
            this.onLabelClicked();
            return true;
        }
        return false;
    }

    public Optional<String> getTooltips() {
        return Optional.empty();
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (!this.clickable || !this.focused) {
            return false;
        }
        if (int_1 != 257 && int_1 != 32 && int_1 != 335) {
            return false;
        }
        this.onLabelClicked();
        return true;
    }

    public boolean changeFocus(boolean boolean_1) {
        if (!this.clickable) {
            return false;
        }
        this.focused = !this.focused;
        return true;
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return this.clickable && (this.isHighlighted(mouseX, mouseY) || this.focused);
    }

    public abstract void onLabelClicked();
}

