/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.cloth.api.ClientUtils;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.ItemCheatingMode;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.client.ItemListOrdering;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.client.SearchArgument;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.SlotWidget;
import me.shedaniel.rei.gui.widget.Widget;
import net.minecraft.class_1074;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.apache.commons.lang3.StringUtils;

public class ItemListOverlay
extends Widget {
    private static final String SPACE = " ";
    private static final String EMPTY = "";
    private static final Comparator<class_1799> ASCENDING_COMPARATOR;
    private static final Comparator<class_1799> DECENDING_COMPARATOR;
    private static List<class_1792> searchBlacklisted;
    private final List<class_1799> currentDisplayed = Lists.newArrayList();
    private final List<SearchArgument[]> lastSearchArgument;
    private List<Widget> widgets;
    private int width = 0;
    private int height = 0;
    private int page;
    private Rectangle rectangle;
    private Rectangle listArea;

    public ItemListOverlay(int page) {
        this.page = page;
        this.lastSearchArgument = Lists.newArrayList();
    }

    public static List<String> tryGetItemStackToolTip(class_1799 itemStack, boolean careAboutAdvanced) {
        if (!searchBlacklisted.contains(itemStack.method_7909())) {
            try {
                return itemStack.method_7950((class_1657)class_310.method_1551().field_1724, (class_1836)(class_310.method_1551().field_1690.field_1827 && careAboutAdvanced ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934)).stream().map(class_2561::method_10863).collect(Collectors.toList());
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(itemStack.method_7909());
            }
        }
        return Collections.singletonList(ItemListOverlay.tryGetItemStackName(itemStack));
    }

    public static String tryGetItemStackName(class_1799 stack) {
        if (!searchBlacklisted.contains(stack.method_7909())) {
            try {
                return stack.method_7964().method_10863();
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(stack.method_7909());
            }
        }
        try {
            return class_1074.method_4662((String)("item." + class_2378.field_11142.method_10221((Object)stack.method_7909()).toString().replace(":", ".")), (Object[])new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public int getFullTotalSlotsPerPage() {
        return this.width * this.height;
    }

    public void render(int int_1, int int_2, float float_1) {
        class_308.method_1450();
        this.widgets.forEach(widget -> widget.render(int_1, int_2, float_1));
        class_746 player = this.minecraft.field_1724;
        if (this.rectangle.contains(ClientUtils.getMouseLocation()) && ClientHelper.getInstance().isCheating() && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
            ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(class_1074.method_4662((String)"text.rei.delete_items", (Object[])new Object[0])));
        }
    }

    public void updateList(DisplayHelper.DisplayBoundsHandler boundsHandler, Rectangle rectangle, int page, String searchTerm, boolean processSearchTerm) {
        this.rectangle = rectangle;
        this.page = page;
        this.widgets = Lists.newLinkedList();
        this.calculateListSize(rectangle);
        if (this.currentDisplayed.isEmpty() || processSearchTerm) {
            this.currentDisplayed.clear();
            this.currentDisplayed.addAll(this.processSearchTerm(searchTerm, RoughlyEnoughItemsCore.getItemRegisterer().getItemList(), ScreenHelper.inventoryStacks));
        }
        int startX = (int)rectangle.getCenterX() - this.width * 9;
        int startY = (int)rectangle.getCenterY() - this.height * 9;
        this.listArea = new Rectangle(startX, startY, this.width * 18, this.height * 18);
        int fitSlotsPerPage = this.getTotalFitSlotsPerPage(startX, startY, this.listArea);
        int j = page * fitSlotsPerPage;
        for (int yy = 0; yy < this.height; ++yy) {
            for (int xx = 0; xx < this.width; ++xx) {
                int x = startX + xx * 18;
                int y = startY + yy * 18;
                if (!this.canBeFit(x, y, this.listArea)) continue;
                if (++j > this.currentDisplayed.size()) break;
                this.widgets.add(new SlotWidget(x, y, Collections.singletonList(this.currentDisplayed.get(j - 1)), false, true, true){

                    @Override
                    protected void queueTooltip(class_1799 itemStack, float delta) {
                        class_746 player = this.minecraft.field_1724;
                        if (!ClientHelper.getInstance().isCheating() || player.field_7514.method_7399().method_7960()) {
                            super.queueTooltip(itemStack, delta);
                        }
                    }

                    @Override
                    public boolean mouseClicked(double mouseX, double mouseY, int button) {
                        if (this.isCurrentRendererItem() && this.isHighlighted(mouseX, mouseY)) {
                            if (ClientHelper.getInstance().isCheating()) {
                                if (this.getCurrentItemStack() != null && !this.getCurrentItemStack().method_7960()) {
                                    class_1799 cheatedStack = this.getCurrentItemStack().method_7972();
                                    if (RoughlyEnoughItemsCore.getConfigManager().getConfig().itemCheatingMode == ItemCheatingMode.REI_LIKE) {
                                        cheatedStack.method_7939(button != 1 ? 1 : cheatedStack.method_7914());
                                    } else if (RoughlyEnoughItemsCore.getConfigManager().getConfig().itemCheatingMode == ItemCheatingMode.JEI_LIKE) {
                                        cheatedStack.method_7939(button != 0 ? 1 : cheatedStack.method_7914());
                                    } else {
                                        cheatedStack.method_7939(1);
                                    }
                                    return ClientHelper.getInstance().tryCheatingStack(cheatedStack);
                                }
                            } else {
                                if (button == 0) {
                                    return ClientHelper.getInstance().executeRecipeKeyBind(this.getCurrentItemStack().method_7972());
                                }
                                if (button == 1) {
                                    return ClientHelper.getInstance().executeUsageKeyBind(this.getCurrentItemStack().method_7972());
                                }
                            }
                        }
                        return false;
                    }
                });
            }
            if (j > this.currentDisplayed.size()) break;
        }
    }

    public int getTotalPage() {
        int fitSlotsPerPage = this.getTotalFitSlotsPerPage(this.listArea.x, this.listArea.y, this.listArea);
        if (fitSlotsPerPage > 0) {
            return class_3532.method_15386((float)(this.getCurrentDisplayed().size() / fitSlotsPerPage));
        }
        return 0;
    }

    public int getTotalFitSlotsPerPage(int startX, int startY, Rectangle listArea) {
        int slots = 0;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!this.canBeFit(startX + x * 18, startY + y * 18, listArea)) continue;
                ++slots;
            }
        }
        return slots;
    }

    public boolean canBeFit(int left, int top, Rectangle listArea) {
        for (DisplayHelper.DisplayBoundsHandler sortedBoundsHandler : RoughlyEnoughItemsCore.getDisplayHelper().getSortedBoundsHandlers(this.minecraft.field_1755.getClass())) {
            class_1269 fit = sortedBoundsHandler.canItemSlotWidgetFit(!RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel, left, top, this.minecraft.field_1755, listArea);
            if (fit == class_1269.field_5811) continue;
            return fit == class_1269.field_5812;
        }
        return true;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        for (Widget widget : this.widgets) {
            if (!widget.keyPressed(int_1, int_2, int_3)) continue;
            return true;
        }
        return false;
    }

    public Rectangle getListArea() {
        return this.listArea;
    }

    public List<class_1799> getCurrentDisplayed() {
        return this.currentDisplayed;
    }

    private List<class_1799> processSearchTerm(String searchTerm, List<class_1799> ol, List<class_1799> inventoryItems) {
        ArrayList workingItems;
        this.lastSearchArgument.clear();
        ArrayList os = Lists.newArrayList(ol);
        ArrayList stacks = Lists.newArrayList();
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().itemListOrdering != ItemListOrdering.registry) {
            if (RoughlyEnoughItemsCore.getConfigManager().getConfig().isAscending) {
                os.sort(ASCENDING_COMPARATOR);
            } else {
                os.sort(DECENDING_COMPARATOR);
            }
        }
        String[] splitSearchTerm = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)searchTerm, (String)"|");
        Arrays.stream(splitSearchTerm).forEachOrdered(s -> {
            String[] split = StringUtils.split((String)s);
            SearchArgument[] arguments = new SearchArgument[split.length];
            for (int i = 0; i < split.length; ++i) {
                String s1 = split[i];
                arguments[i] = s1.startsWith("@-") || s1.startsWith("-@") ? new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(2), false) : (s1.startsWith("@") ? new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(1), true) : (s1.startsWith("#-") || s1.startsWith("-#") ? new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(2), false) : (s1.startsWith("#") ? new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(1), true) : (s1.startsWith("-") ? new SearchArgument(SearchArgument.ArgumentType.TEXT, s1.substring(1), false) : new SearchArgument(SearchArgument.ArgumentType.TEXT, s1, true)))));
            }
            if (arguments.length > 0) {
                this.lastSearchArgument.add(arguments);
            } else {
                this.lastSearchArgument.add(new SearchArgument[]{SearchArgument.ALWAYS});
            }
        });
        os.stream().filter(itemStack -> ItemListOverlay.filterItem(itemStack, this.lastSearchArgument)).forEachOrdered(stacks::add);
        ArrayList arrayList = workingItems = RoughlyEnoughItemsCore.getConfigManager().isCraftableOnlyEnabled() && !stacks.isEmpty() && !inventoryItems.isEmpty() ? Lists.newArrayList() : Lists.newArrayList(ol);
        if (RoughlyEnoughItemsCore.getConfigManager().isCraftableOnlyEnabled()) {
            RecipeHelper.getInstance().findCraftableByItems(inventoryItems).forEach(workingItems::add);
            workingItems.addAll(inventoryItems);
        }
        if (!RoughlyEnoughItemsCore.getConfigManager().isCraftableOnlyEnabled()) {
            return stacks;
        }
        return stacks.stream().filter(itemStack -> workingItems.stream().anyMatch(stack -> stack.method_7962(itemStack))).collect(Collectors.toList());
    }

    public List<SearchArgument[]> getLastSearchArgument() {
        return this.lastSearchArgument;
    }

    public static boolean filterItem(class_1799 itemStack, List<SearchArgument[]> arguments) {
        if (arguments.isEmpty()) {
            return true;
        }
        String mod = ClientHelper.getInstance().getModFromItem(itemStack.method_7909()).toLowerCase();
        String tooltips = ItemListOverlay.tryGetItemStackToolTip(itemStack, true).stream().skip(1L).collect(Collectors.joining(EMPTY)).replace(SPACE, EMPTY).toLowerCase();
        String name = ItemListOverlay.tryGetItemStackName(itemStack).replace(SPACE, EMPTY).toLowerCase();
        for (SearchArgument[] arguments1 : arguments) {
            boolean b = true;
            for (SearchArgument argument : arguments1) {
                if (argument.getArgumentType().equals((Object)SearchArgument.ArgumentType.ALWAYS)) {
                    return true;
                }
                if (argument.getArgumentType().equals((Object)SearchArgument.ArgumentType.MOD) && SearchArgument.getFunction(!argument.isInclude()).apply(mod.indexOf(argument.getText())).booleanValue()) {
                    b = false;
                    break;
                }
                if (argument.getArgumentType().equals((Object)SearchArgument.ArgumentType.TOOLTIP) && SearchArgument.getFunction(!argument.isInclude()).apply(tooltips.indexOf(argument.getText())).booleanValue()) {
                    b = false;
                    break;
                }
                if (!argument.getArgumentType().equals((Object)SearchArgument.ArgumentType.TEXT) || !SearchArgument.getFunction(!argument.isInclude()).apply(name.indexOf(argument.getText())).booleanValue()) continue;
                b = false;
                break;
            }
            if (!b) continue;
            return true;
        }
        return false;
    }

    private boolean filterItem(class_1799 itemStack, SearchArgument ... arguments) {
        if (arguments.length == 0) {
            return true;
        }
        String mod = ClientHelper.getInstance().getModFromItem(itemStack.method_7909()).toLowerCase();
        String tooltips = ItemListOverlay.tryGetItemStackToolTip(itemStack, false).stream().skip(1L).collect(Collectors.joining(EMPTY)).replace(SPACE, EMPTY).toLowerCase();
        String name = ItemListOverlay.tryGetItemStackName(itemStack).replace(SPACE, EMPTY).toLowerCase();
        for (SearchArgument argument : arguments) {
            if (argument.getArgumentType().equals((Object)SearchArgument.ArgumentType.MOD) && SearchArgument.getFunction(!argument.isInclude()).apply(mod.indexOf(argument.getText())).booleanValue()) {
                return false;
            }
            if (argument.getArgumentType().equals((Object)SearchArgument.ArgumentType.TOOLTIP) && SearchArgument.getFunction(!argument.isInclude()).apply(tooltips.indexOf(argument.getText())).booleanValue()) {
                return false;
            }
            if (!argument.getArgumentType().equals((Object)SearchArgument.ArgumentType.TEXT) || !SearchArgument.getFunction(!argument.isInclude()).apply(name.indexOf(argument.getText())).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public void calculateListSize(Rectangle rect) {
        int xOffset = 0;
        int yOffset = 0;
        this.width = 0;
        this.height = 0;
        do {
            xOffset += 18;
            if (this.height == 0) {
                ++this.width;
            }
            if (xOffset + 19 <= rect.width) continue;
            xOffset = 0;
            yOffset += 18;
            ++this.height;
        } while (yOffset + 19 <= rect.height);
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (this.rectangle.contains(double_1, double_2)) {
            class_746 player = this.minecraft.field_1724;
            if (ClientHelper.getInstance().isCheating() && !player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            if (!player.field_7514.method_7399().method_7960() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                return false;
            }
            for (Widget widget : this.children()) {
                if (!widget.mouseClicked(double_1, double_2, int_1)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Widget> children() {
        return this.widgets;
    }

    static {
        searchBlacklisted = Lists.newArrayList();
        ASCENDING_COMPARATOR = (itemStack, t1) -> {
            if (RoughlyEnoughItemsCore.getConfigManager().getConfig().itemListOrdering.equals((Object)ItemListOrdering.name)) {
                return ItemListOverlay.tryGetItemStackName(itemStack).compareToIgnoreCase(ItemListOverlay.tryGetItemStackName(t1));
            }
            if (RoughlyEnoughItemsCore.getConfigManager().getConfig().itemListOrdering.equals((Object)ItemListOrdering.item_groups)) {
                List<class_1761> itemGroups = Arrays.asList(class_1761.field_7921);
                return itemGroups.indexOf(itemStack.method_7909().method_7859()) - itemGroups.indexOf(t1.method_7909().method_7859());
            }
            return 0;
        };
        DECENDING_COMPARATOR = ASCENDING_COMPARATOR.reversed();
    }
}

