/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.api;

import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public interface ItemRegistry {
    
    /**
     * Gets the current unmodifiable item list
     *
     * @return an unmodifiable item list
     */
    List<class_1799> getItemList();
    
    /**
     * Gets the current modifiable item list
     *
     * @return an modifiable item list
     */
    @Deprecated
    List<class_1799> getModifiableItemList();
    
    /**
     * Gets all possible stacks from an item
     *
     * @param item the item to find
     * @return the array of possible stacks
     */
    class_1799[] getAllStacksFromItem(class_1792 item);
    
    /**
     * Registers an new stack to the item list
     *
     * @param afterItem the stack to put after
     * @param stack     the stack to register
     */
    void registerItemStack(class_1792 afterItem, class_1799 stack);
    
    /**
     * Registers multiple stacks to the item list
     *
     * @param afterItem the stack to put after
     * @param stacks    the stacks to register
     */
    default void registerItemStack(class_1792 afterItem, class_1799... stacks) {
        for(class_1799 stack : stacks)
            if (stack != null && !stack.method_7960())
                registerItemStack(afterItem, stack);
    }
    
    /**
     * Registers multiple stacks to the item list
     *
     * @param stacks the stacks to register
     */
    default void registerItemStack(class_1799... stacks) {
        for(class_1799 stack : stacks)
            if (stack != null && !stack.method_7960())
                registerItemStack(null, stack);
    }
    
    /**
     * Checks if a stack is already registered
     *
     * @param stack the stack to check
     * @return whether the stack has been registered
     */
    default boolean alreadyContain(class_1799 stack) {
        return getItemList().stream().anyMatch(stack1 -> class_1799.method_7973(stack, stack1));
    }
    
}
