/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.api;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2960;

public interface RecipeDisplay<T extends class_1860> {
    
    /**
     * @return the optional recipe
     */
    Optional<? extends class_1860> getRecipe();
    
    /**
     * @return a list of items
     */
    List<List<class_1799>> getInput();
    
    /**
     * @return a list of outputs
     */
    List<class_1799> getOutput();
    
    /**
     * Gets the required items used in craftable filters
     *
     * @return the list of required items
     */
    default List<List<class_1799>> getRequiredItems() {
        return Lists.newArrayList();
    }
    
    /**
     * Gets the recipe display category identifier
     *
     * @return the identifier of the category
     */
    class_2960 getRecipeCategory();
    
}
