/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.client;

import com.google.common.collect.Lists;
import me.shedaniel.rei.api.ItemRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class ItemRegistryImpl implements ItemRegistry {
    
    private final List<class_1799> itemList = Lists.newLinkedList();
    
    @Override
    public List<class_1799> getItemList() {
        return Collections.unmodifiableList(itemList);
    }
    
    @SuppressWarnings("deprecation")
    @Override
    public List<class_1799> getModifiableItemList() {
        return itemList;
    }
    
    @Override
    public class_1799[] getAllStacksFromItem(class_1792 item) {
        class_2371<class_1799> list = class_2371.method_10211();
        list.add(item.method_7854());
        item.method_7850(item.method_7859(), list);
        TreeSet<class_1799> stackSet = list.stream().collect(Collectors.toCollection(() -> new TreeSet<class_1799>((p1, p2) -> class_1799.method_7973(p1, p2) ? 0 : 1)));
        return Lists.newArrayList(stackSet).toArray(new class_1799[0]);
    }
    
    @Override
    public void registerItemStack(class_1792 afterItem, class_1799 stack) {
        if (!stack.method_7960() && !alreadyContain(stack))
            if (afterItem == null || afterItem.equals(class_1802.field_8162))
                itemList.add(stack);
            else {
                int last = itemList.size();
                for(int i = 0; i < itemList.size(); i++)
                    if (itemList.get(i).method_7909().equals(afterItem))
                        last = i + 1;
                itemList.add(last, stack);
            }
    }
    
}
