/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.plugin;

import me.shedaniel.rei.api.RecipeDisplay;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3861;
import net.minecraft.class_3866;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DefaultSmeltingDisplay implements RecipeDisplay<class_3861> {
    
    private class_3861 display;
    private List<List<class_1799>> input;
    private List<class_1799> output;
    
    public DefaultSmeltingDisplay(class_3861 recipe) {
        this.display = recipe;
        this.input = recipe.method_8117().stream().map(i -> Arrays.asList(i.method_8105())).collect(Collectors.toList());
        this.input.add(class_3866.method_11196().keySet().stream().map(class_1792::method_7854).collect(Collectors.toList()));
        this.output = Collections.singletonList(recipe.method_8110());
    }
    
    @Override
    public Optional<class_3861> getRecipe() {
        return Optional.ofNullable(display);
    }
    
    @Override
    public List<List<class_1799>> getInput() {
        return input;
    }
    
    public List<class_1799> getFuel() {
        return input.get(1);
    }
    
    @Override
    public List<class_1799> getOutput() {
        return output;
    }
    
    @Override
    public class_2960 getRecipeCategory() {
        return DefaultPlugin.SMELTING;
    }
    
    @Override
    public List<List<class_1799>> getRequiredItems() {
        return input;
    }
    
}
