/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import me.shedaniel.cloth.api.ClientUtils;
import me.shedaniel.cloth.hooks.ClothClientHooks;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.ItemRegistry;
import me.shedaniel.rei.api.PluginDisabler;
import me.shedaniel.rei.api.REIPlugin;
import me.shedaniel.rei.api.REIPluginEntry;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.client.ConfigManagerImpl;
import me.shedaniel.rei.client.DisplayHelperImpl;
import me.shedaniel.rei.client.ItemRegistryImpl;
import me.shedaniel.rei.client.PluginDisablerImpl;
import me.shedaniel.rei.client.RecipeHelperImpl;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.widget.ItemListOverlay;
import me.shedaniel.rei.listeners.RecipeBookGuiHooks;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1074;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_507;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoughlyEnoughItemsCore
implements ClientModInitializer {
    public static final Logger LOGGER;
    private static final RecipeHelper RECIPE_HELPER;
    private static final PluginDisabler PLUGIN_DISABLER;
    private static final ItemRegistry ITEM_REGISTRY;
    private static final DisplayHelper DISPLAY_HELPER;
    private static final Map<class_2960, REIPluginEntry> plugins;
    private static final ExecutorService SYNC_RECIPES;
    private static ConfigManagerImpl configManager;

    public static RecipeHelper getRecipeHelper() {
        return RECIPE_HELPER;
    }

    public static ConfigManager getConfigManager() {
        return configManager;
    }

    public static ItemRegistry getItemRegisterer() {
        return ITEM_REGISTRY;
    }

    public static PluginDisabler getPluginDisabler() {
        return PLUGIN_DISABLER;
    }

    public static DisplayHelper getDisplayHelper() {
        return DISPLAY_HELPER;
    }

    @Deprecated
    public static REIPluginEntry registerPlugin(class_2960 identifier, REIPluginEntry plugin) {
        plugins.put(identifier, plugin);
        LOGGER.info("[REI] Registered plugin %s from %s", (Object)identifier.toString(), (Object)plugin.getClass().getSimpleName());
        plugin.onFirstLoad(RoughlyEnoughItemsCore.getPluginDisabler());
        return plugin;
    }

    public static List<REIPluginEntry> getPlugins() {
        return new LinkedList<REIPluginEntry>(plugins.values());
    }

    public static Optional<class_2960> getPluginIdentifier(REIPluginEntry plugin) {
        for (class_2960 identifier : plugins.keySet()) {
            if (identifier == null || !plugins.get(identifier).equals(plugin)) continue;
            return Optional.of(identifier);
        }
        return Optional.empty();
    }

    public static boolean hasPermissionToUsePackets() {
        try {
            class_310.method_1551().method_1562().method_2875().method_9259(0);
            return RoughlyEnoughItemsCore.hasOperatorPermission() && RoughlyEnoughItemsCore.canUsePackets();
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public static boolean hasOperatorPermission() {
        try {
            return class_310.method_1551().method_1562().method_2875().method_9259(1);
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public static boolean canUsePackets() {
        return ClientSidePacketRegistry.INSTANCE.canServerReceive(RoughlyEnoughItemsNetwork.CREATE_ITEMS_PACKET) && ClientSidePacketRegistry.INSTANCE.canServerReceive(RoughlyEnoughItemsNetwork.DELETE_ITEMS_PACKET);
    }

    public void onInitializeClient() {
        configManager = new ConfigManagerImpl();
        this.registerClothEvents();
        this.discoverOldPlugins();
        this.discoverPluginEntries();
        ClientSidePacketRegistry.INSTANCE.register(RoughlyEnoughItemsNetwork.CREATE_ITEMS_MESSAGE_PACKET, (packetContext, packetByteBuf) -> {
            class_1799 stack = packetByteBuf.method_10819();
            String player = packetByteBuf.method_10800(Short.MAX_VALUE);
            packetContext.getPlayer().method_7353((class_2561)new class_2585(class_1074.method_4662((String)"text.rei.cheat_items", (Object[])new Object[0]).replaceAll("\\{item_name}", ItemListOverlay.tryGetItemStackName(stack.method_7972())).replaceAll("\\{item_count}", stack.method_7972().method_7947() + "").replaceAll("\\{player_name}", player)), false);
        });
    }

    private void discoverPluginEntries() {
        for (REIPluginEntry reiPlugin : FabricLoader.getInstance().getEntrypoints("rei_plugins", REIPluginEntry.class)) {
            try {
                if (reiPlugin instanceof REIPlugin) {
                    throw new IllegalStateException("REI Plugins on Entry Points should not implement REIPlugin");
                }
                RoughlyEnoughItemsCore.registerPlugin(reiPlugin.getPluginIdentifier(), reiPlugin);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("[REI] Can't load REI plugins from %s: %s", reiPlugin.getClass(), (Object)e.getLocalizedMessage());
            }
        }
    }

    private void discoverOldPlugins() {
        ArrayList list = Lists.newArrayList();
        for (ModMetadata metadata2 : FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).filter(metadata -> metadata.containsCustomElement("roughlyenoughitems:plugins")).collect(Collectors.toList())) {
            LOGGER.warn("[REI] %s(%s) is still using the old way to register its plugin! Support will be dropped in the future!", (Object)metadata2.getName(), (Object)metadata2.getId());
            try {
                JsonElement pluginsElement = metadata2.getCustomElement("roughlyenoughitems:plugins");
                if (pluginsElement.isJsonArray()) {
                    for (JsonElement element : pluginsElement.getAsJsonArray()) {
                        if (element.isJsonObject()) {
                            this.loadPluginFromJsonObject(list, metadata2, element.getAsJsonObject());
                            continue;
                        }
                        throw new IllegalStateException("Custom Element in an array is not an object.");
                    }
                    continue;
                }
                if (pluginsElement.isJsonObject()) {
                    this.loadPluginFromJsonObject(list, metadata2, pluginsElement.getAsJsonObject());
                    continue;
                }
                throw new IllegalStateException("Custom Element not an array or an object.");
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("[REI] Can't load REI plugins from %s: %s", (Object)metadata2.getId(), (Object)e.getLocalizedMessage());
            }
        }
        for (class_3545 pair : list) {
            String s = (String)pair.method_15441();
            try {
                Class<?> aClass = Class.forName(s);
                if (!REIPlugin.class.isAssignableFrom(aClass)) {
                    LOGGER.error("[REI] Plugin class from %s is not implementing REIPlugin!", (Object)s);
                    break;
                }
                REIPlugin o = (REIPlugin)REIPlugin.class.cast(aClass.newInstance());
                RoughlyEnoughItemsCore.registerPlugin((class_2960)pair.method_15442(), o);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.error("[REI] Can't load REI plugin class from %s!", (Object)s);
            }
            catch (ClassCastException e) {
                LOGGER.error("[REI] Failed to cast plugin class from %s to REIPlugin!", (Object)s);
            }
        }
    }

    private void loadPluginFromJsonObject(List<class_3545<class_2960, String>> list, ModMetadata modMetadata, JsonObject object) {
        String namespace = modMetadata.getId();
        if (object.has("namespace")) {
            namespace = object.get("namespace").getAsString();
        }
        String id = object.get("id").getAsString();
        String className = object.get("class").getAsString();
        list.add((class_3545<class_2960, String>)new class_3545((Object)new class_2960(namespace, id), (Object)className));
    }

    private void registerClothEvents() {
        ClothClientHooks.SYNC_RECIPES.register((minecraftClient, recipeManager, synchronizeRecipesS2CPacket) -> {
            if (RoughlyEnoughItemsCore.getConfigManager().getConfig().registerRecipesInAnotherThread) {
                CompletableFuture.runAsync(() -> ((RecipeHelperImpl)RoughlyEnoughItemsCore.getRecipeHelper()).recipesLoaded(recipeManager), SYNC_RECIPES);
            } else {
                ((RecipeHelperImpl)RoughlyEnoughItemsCore.getRecipeHelper()).recipesLoaded(recipeManager);
            }
        });
        ClothClientHooks.SCREEN_ADD_BUTTON.register((minecraftClient, screen, abstractButtonWidget) -> {
            if (RoughlyEnoughItemsCore.getConfigManager().getConfig().disableRecipeBook && screen instanceof class_465 && abstractButtonWidget instanceof class_344) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        ClothClientHooks.SCREEN_INIT_POST.register((minecraftClient, screen, screenHooks) -> {
            if (screen instanceof class_465) {
                if (screen instanceof class_490 && minecraftClient.field_1761.method_2914()) {
                    return;
                }
                ScreenHelper.setLastContainerScreen((class_465)screen);
                boolean alreadyAdded = false;
                for (class_364 element : Lists.newArrayList((Iterable)screenHooks.cloth_getInputListeners())) {
                    if (!ContainerScreenOverlay.class.isAssignableFrom(element.getClass())) continue;
                    if (alreadyAdded) {
                        screenHooks.cloth_getInputListeners().remove(element);
                        continue;
                    }
                    alreadyAdded = true;
                }
                if (!alreadyAdded) {
                    screenHooks.cloth_getInputListeners().add(ScreenHelper.getLastOverlay(true, false));
                }
            }
        });
        ClothClientHooks.SCREEN_RENDER_POST.register((minecraftClient, screen, i, i1, v) -> {
            if (screen instanceof class_465) {
                ScreenHelper.getLastOverlay().render(i, i1, v);
            }
        });
        ClothClientHooks.SCREEN_MOUSE_CLICKED.register((minecraftClient, screen, v, v1, i) -> {
            if (screen instanceof class_481 && ScreenHelper.isOverlayVisible() && ScreenHelper.getLastOverlay().mouseClicked(v, v1, i)) {
                screen.setFocused((class_364)ScreenHelper.getLastOverlay());
                if (i == 0) {
                    screen.setDragging(true);
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        ClothClientHooks.SCREEN_MOUSE_SCROLLED.register((minecraftClient, screen, v, v1, v2) -> {
            if (screen instanceof class_465 && ScreenHelper.isOverlayVisible() && ScreenHelper.getLastOverlay().isInside(ClientUtils.getMouseLocation()) && ScreenHelper.getLastOverlay().mouseScrolled(v, v1, v2)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        ClothClientHooks.SCREEN_CHAR_TYPED.register((minecraftClient, screen, character, keyCode) -> {
            if (screen instanceof class_465 && ScreenHelper.getLastOverlay().charTyped(character, keyCode)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        ClothClientHooks.SCREEN_LATE_RENDER.register((minecraftClient, screen, i, i1, v) -> {
            if (!ScreenHelper.isOverlayVisible()) {
                return;
            }
            if (screen instanceof class_465) {
                ScreenHelper.getLastOverlay().lateRender(i, i1, v);
            }
        });
        ClothClientHooks.SCREEN_KEY_PRESSED.register((minecraftClient, screen, i, i1, i2) -> {
            if (screen.getFocused() != null && screen.getFocused() instanceof class_342 || screen.getFocused() instanceof class_507 && ((RecipeBookGuiHooks)screen.getFocused()).rei_getSearchField() != null && ((RecipeBookGuiHooks)screen.getFocused()).rei_getSearchField().isFocused()) {
                return class_1269.field_5811;
            }
            if (screen instanceof class_465 && ScreenHelper.getLastOverlay().keyPressed(i, i1, i2)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
    }

    static {
        RECIPE_HELPER = new RecipeHelperImpl();
        PLUGIN_DISABLER = new PluginDisablerImpl();
        ITEM_REGISTRY = new ItemRegistryImpl();
        DISPLAY_HELPER = new DisplayHelperImpl();
        plugins = Maps.newHashMap();
        SYNC_RECIPES = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "REI-SyncRecipes"));
        LOGGER = LogManager.getFormatterLogger((String)"REI");
    }
}

