/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;
import net.minecraft.class_1269;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_437;

public class BaseBoundsHandlerImpl
implements BaseBoundsHandler {
    private static final Function<Rectangle, String> RECTANGLE_STRING_FUNCTION = rectangle -> rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
    private static final Comparator<Rectangle> RECTANGLE_COMPARATOR = BaseBoundsHandlerImpl::compare;
    private static final Comparator<class_3545<class_3545<Class<? extends class_437>, Float>, BaseBoundsHandler.ExclusionZoneSupplier>> LIST_PAIR_COMPARATOR;
    private String lastArea = null;
    private List<class_3545<class_3545<Class<? extends class_437>, Float>, BaseBoundsHandler.ExclusionZoneSupplier>> list = Lists.newArrayList();

    private static int compare(Rectangle o1, Rectangle o2) {
        return RECTANGLE_STRING_FUNCTION.apply(o1).compareTo(RECTANGLE_STRING_FUNCTION.apply(o2));
    }

    @Override
    public Class getBaseSupportedClass() {
        return class_437.class;
    }

    @Override
    public Rectangle getLeftBounds(class_437 screen) {
        return new Rectangle();
    }

    @Override
    public Rectangle getRightBounds(class_437 screen) {
        return new Rectangle();
    }

    @Override
    public float getPriority() {
        return -5.0f;
    }

    @Override
    public class_1269 isInZone(boolean isOnRightSide, double mouseX, double mouseY) {
        for (Rectangle zone : this.getCurrentExclusionZones(class_310.method_1551().field_1755.getClass(), isOnRightSide)) {
            if (!zone.contains(mouseX, mouseY)) continue;
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    @Override
    public boolean shouldRecalculateArea(boolean isOnRightSide, Rectangle rectangle) {
        if (this.lastArea == null) {
            this.lastArea = this.getStringFromCurrent(isOnRightSide);
            return false;
        }
        if (this.lastArea.contentEquals(this.getStringFromCurrent(isOnRightSide))) {
            return false;
        }
        this.lastArea = this.getStringFromCurrent(isOnRightSide);
        return true;
    }

    private DisplayHelper.DisplayBoundsHandler getHandler() {
        return RoughlyEnoughItemsCore.getDisplayHelper().getResponsibleBoundsHandler(class_310.method_1551().field_1755.getClass());
    }

    private String getStringFromCurrent(boolean isOnRightSide) {
        return this.getStringFromAreas(isOnRightSide ? this.getHandler().getRightBounds(class_310.method_1551().field_1755) : this.getHandler().getLeftBounds(class_310.method_1551().field_1755), this.getCurrentExclusionZones(class_310.method_1551().field_1755.getClass(), isOnRightSide));
    }

    @Override
    public class_1269 canItemSlotWidgetFit(boolean isOnRightSide, int left, int top, class_437 screen, Rectangle fullBounds) {
        List<Rectangle> currentExclusionZones = this.getCurrentExclusionZones(class_310.method_1551().field_1755.getClass(), isOnRightSide);
        for (Rectangle currentExclusionZone : currentExclusionZones) {
            if (left + 18 < currentExclusionZone.x || top + 18 < currentExclusionZone.y || left > currentExclusionZone.x + currentExclusionZone.width || top > currentExclusionZone.y + currentExclusionZone.height) continue;
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    @Override
    public List<Rectangle> getCurrentExclusionZones(Class<? extends class_437> currentScreenClass, boolean isOnRightSide) {
        List<class_3545> only = this.list.stream().filter(pair -> ((Class)((class_3545)pair.method_15442()).method_15442()).isAssignableFrom(currentScreenClass)).collect(Collectors.toList());
        only.sort(LIST_PAIR_COMPARATOR);
        ArrayList rectangles = Lists.newArrayList();
        only.forEach(pair -> rectangles.addAll(((BaseBoundsHandler.ExclusionZoneSupplier)pair.method_15441()).apply(isOnRightSide)));
        return rectangles;
    }

    @Override
    public void registerExclusionZones(Class<? extends class_437> screenClass, BaseBoundsHandler.ExclusionZoneSupplier supplier) {
        this.list.add((class_3545<class_3545<Class<? extends class_437>, Float>, BaseBoundsHandler.ExclusionZoneSupplier>)new class_3545((Object)new class_3545(screenClass, (Object)Float.valueOf(0.0f)), (Object)supplier));
    }

    public String getStringFromAreas(Rectangle rectangle, List<Rectangle> exclusionZones) {
        ArrayList sorted = Lists.newArrayList(exclusionZones);
        sorted.sort(RECTANGLE_COMPARATOR);
        return RECTANGLE_STRING_FUNCTION.apply(rectangle) + ":" + sorted.stream().map(RECTANGLE_STRING_FUNCTION::apply).collect(Collectors.joining("|"));
    }

    static {
        Comparator<class_3545> comparator = Comparator.comparingDouble(value -> ((Float)((class_3545)value.method_15442()).method_15441()).floatValue());
        LIST_PAIR_COMPARATOR = comparator.reversed();
    }
}

