/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.client.ConfigObject;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ConfigManagerImpl
implements ConfigManager {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Jankson JANKSON = Jankson.builder().build();
    private final File configFile;
    private final File veryOldConfigFile = new File(FabricLoader.getInstance().getConfigDirectory(), "rei.json");
    private final File oldConfigFile = new File(FabricLoader.getInstance().getConfigDirectory(), "roughlyenoughitems/config.json");
    private ConfigObject config;
    private boolean craftableOnly = false;

    public ConfigManagerImpl() {
        this.configFile = new File(FabricLoader.getInstance().getConfigDirectory(), "roughlyenoughitems/config.json5");
        try {
            this.loadConfig();
            RoughlyEnoughItemsCore.LOGGER.info("[REI] Config is loaded.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveConfig() throws IOException {
        this.configFile.getParentFile().mkdirs();
        if (!this.configFile.exists() && !this.configFile.createNewFile()) {
            RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to save config! Overwriting with default config.");
            this.config = new ConfigObject();
            return;
        }
        try {
            String result = JANKSON.toJson((Object)this.config).toJson(true, true, 0);
            if (!this.configFile.exists()) {
                this.configFile.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(this.configFile, false);
            out.write(result.getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to save config! Overwriting with default config.");
            this.config = new ConfigObject();
            return;
        }
    }

    @Override
    public void loadConfig() throws IOException {
        this.configFile.getParentFile().mkdirs();
        if (!this.configFile.exists() && this.veryOldConfigFile.exists()) {
            RoughlyEnoughItemsCore.LOGGER.info("[REI] Detected old config file, trying to move it.");
            try {
                Files.move(this.veryOldConfigFile.toPath(), this.configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                e.printStackTrace();
                RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to move config file.");
            }
        }
        if (!this.configFile.exists() && this.oldConfigFile.exists()) {
            RoughlyEnoughItemsCore.LOGGER.info("[REI] Detected old config file, trying to move it.");
            try {
                Files.move(this.oldConfigFile.toPath(), this.configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                e.printStackTrace();
                RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to move config file.");
            }
        }
        if (!this.configFile.exists() || !this.configFile.canRead()) {
            RoughlyEnoughItemsCore.LOGGER.warn("[REI] Config not found! Creating one.");
            this.config = new ConfigObject();
            this.saveConfig();
            return;
        }
        boolean failed = false;
        try {
            JsonObject configJson = JANKSON.load(this.configFile);
            String regularized = configJson.toJson(false, false, 0);
            this.config = (ConfigObject)GSON.fromJson(regularized, ConfigObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            failed = true;
        }
        if (failed || this.config == null) {
            RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to load config! Overwriting with default config.");
            this.config = new ConfigObject();
        }
        this.saveConfig();
    }

    @Override
    public ConfigObject getConfig() {
        return this.config;
    }

    @Override
    public boolean isCraftableOnlyEnabled() {
        return this.craftableOnly;
    }

    @Override
    public void toggleCraftableOnly() {
        this.craftableOnly = !this.craftableOnly;
    }

    @Override
    public void openConfigScreen(class_437 parent) {
        class_310.method_1551().method_1507(this.getConfigScreen(parent));
    }

    @Override
    public class_437 getConfigScreen(final class_437 parent) {
        if (FabricLoader.getInstance().isModLoaded("cloth-config2")) {
            try {
                return (class_437)class_437.class.cast(Class.forName("me.shedaniel.rei.utils.ClothScreenRegistry").getDeclaredMethod("getConfigScreen", class_437.class).invoke(null, parent));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new class_437((class_2561)new class_2585("")){

            public void render(int int_1, int int_2, float float_1) {
                this.renderDirtBackground(0);
                List list = this.minecraft.field_1772.method_1728(class_1074.method_4662((String)"text.rei.config_api_failed", (Object[])new Object[0]), this.width - 100);
                float f = this.height / 2;
                this.minecraft.field_1772.getClass();
                int y = (int)(f - 9.0f * 1.3f / 2.0f * (float)list.size());
                for (int i = 0; i < list.size(); ++i) {
                    String s = (String)list.get(i);
                    this.drawCenteredString(this.minecraft.field_1772, s, this.width / 2, y, -1);
                    this.minecraft.field_1772.getClass();
                    y += 9;
                }
                super.render(int_1, int_2, float_1);
            }

            protected void init() {
                super.init();
                this.addButton((class_339)new class_4185(this.width / 2 - 100, this.height - 26, 200, 20, class_1074.method_4662((String)"text.rei.back", (Object[])new Object[0]), buttonWidget -> this.minecraft.method_1507(parent)));
            }

            public boolean keyPressed(int int_1, int int_2, int int_3) {
                if (int_1 == 256 && this.shouldCloseOnEsc()) {
                    this.minecraft.method_1507(parent);
                    return true;
                }
                return super.keyPressed(int_1, int_2, int_3);
            }
        };
    }
}

