/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.shedaniel.cloth.api.ClientUtils;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.Renderable;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.client.ClientHelperImpl;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.renderables.ItemStackRenderer;
import me.shedaniel.rei.gui.widget.HighlightableWidget;
import me.shedaniel.rei.gui.widget.ItemListOverlay;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_364;

public class SlotWidget
extends HighlightableWidget {
    public static final class_2960 RECIPE_GUI = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer.png");
    public static final class_2960 RECIPE_GUI_DARK = new class_2960("roughlyenoughitems", "textures/gui/recipecontainer_dark.png");
    private List<Renderer> renderers = new LinkedList<Renderer>();
    private boolean drawBackground;
    private boolean showToolTips;
    private boolean clickToMoreRecipes;
    private boolean drawHighlightedBackground;
    protected int x;
    protected int y;

    public SlotWidget(int x, int y, class_1799 itemStack, boolean drawBackground, boolean showToolTips) {
        this(x, y, (Collection<class_1799>)Collections.singletonList(itemStack), drawBackground, showToolTips);
    }

    public SlotWidget(int x, int y, Collection<class_1799> itemList, boolean drawBackground, boolean showToolTips) {
        this(x, y, itemList.stream().map(Renderable::fromItemStack).collect(Collectors.toList()), drawBackground, showToolTips);
    }

    public SlotWidget(int x, int y, List<Renderer> renderers, boolean drawBackground, boolean showToolTips) {
        this.renderers = renderers;
        this.drawBackground = drawBackground;
        this.showToolTips = showToolTips;
        this.x = x;
        this.y = y;
        this.clickToMoreRecipes = false;
        this.drawHighlightedBackground = true;
    }

    public SlotWidget(int x, int y, List<class_1799> itemList, boolean drawBackground, boolean showToolTips, boolean clickToMoreRecipes) {
        this(x, y, (Collection<class_1799>)itemList, drawBackground, showToolTips);
        this.clickToMoreRecipes = clickToMoreRecipes;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean isShowToolTips() {
        return this.showToolTips;
    }

    public void setShowToolTips(boolean showToolTips) {
        this.showToolTips = showToolTips;
    }

    public boolean isClickToMoreRecipes() {
        return this.clickToMoreRecipes;
    }

    public void setClickToMoreRecipes(boolean clickToMoreRecipes) {
        this.clickToMoreRecipes = clickToMoreRecipes;
    }

    public boolean isDrawHighlightedBackground() {
        return this.drawHighlightedBackground;
    }

    public void setDrawHighlightedBackground(boolean drawHighlightedBackground) {
        this.drawHighlightedBackground = drawHighlightedBackground;
    }

    public List<? extends class_364> children() {
        return Collections.emptyList();
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public void render(int mouseX, int mouseY, float delta) {
        Renderer renderer = this.getCurrentRenderer();
        boolean darkTheme = ScreenHelper.isDarkModeEnabled();
        if (this.drawBackground) {
            this.minecraft.method_1531().method_4618(darkTheme ? RECIPE_GUI_DARK : RECIPE_GUI);
            this.blit(this.x - 1, this.y - 1, 0, 222, 18, 18);
        }
        boolean highlighted = this.isHighlighted(mouseX, mouseY);
        if (this.drawHighlightedBackground && highlighted) {
            GlStateManager.disableLighting();
            GlStateManager.disableDepthTest();
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            int color = darkTheme ? -10592674 : -2130706433;
            this.fillGradient(this.x, this.y, this.x + 16, this.y + 16, color, color);
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.enableLighting();
            GlStateManager.enableDepthTest();
        }
        if (this.isCurrentRendererItem() && !this.getCurrentItemStack().method_7960()) {
            renderer.setBlitOffset(200);
            renderer.render(this.x + 8, this.y + 6, mouseX, mouseY, delta);
            if (!this.getCurrentItemStack().method_7960() && highlighted && this.showToolTips) {
                this.queueTooltip(this.getCurrentItemStack(), delta);
            }
        } else {
            renderer.setBlitOffset(200);
            renderer.render(this.x + 8, this.y + 6, mouseX, mouseY, delta);
        }
    }

    public int getBlitOffset() {
        return this.blitOffset;
    }

    public void setBlitOffset(int offset) {
        this.blitOffset = offset;
    }

    protected void queueTooltip(class_1799 itemStack, float delta) {
        ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(this.getTooltip(itemStack)));
    }

    protected List<String> getTooltip(class_1799 itemStack) {
        String modString = ClientHelper.getInstance().getFormattedModFromItem(itemStack.method_7909());
        ArrayList toolTip = Lists.newArrayList(ItemListOverlay.tryGetItemStackToolTip(itemStack, true));
        String s1 = ClientHelperImpl.instance.getFormattedModNoItalicFromItem(itemStack.method_7909()).toLowerCase();
        toolTip.addAll(this.getExtraToolTips(itemStack));
        if (!modString.isEmpty()) {
            toolTip.removeIf(s -> s.toLowerCase().contains(s1));
            toolTip.add(modString);
        }
        return toolTip;
    }

    protected List<String> getExtraToolTips(class_1799 stack) {
        return Collections.emptyList();
    }

    protected String getItemCountOverlay(class_1799 currentStack) {
        return "";
    }

    public class_1799 getCurrentItemStack() {
        if (this.getCurrentRenderer() instanceof ItemStackRenderer) {
            return ((ItemStackRenderer)this.getCurrentRenderer()).getItemStack();
        }
        return class_1799.field_8037;
    }

    public Renderer getCurrentRenderer() {
        if (this.renderers.size() == 0) {
            return Renderable.empty();
        }
        return this.renderers.get(class_3532.method_15357((double)((double)(System.currentTimeMillis() / 500L) % (double)this.renderers.size() / 1.0)));
    }

    public void setItemList(List<class_1799> itemList) {
        this.setRenderers(itemList.stream().map(Renderable::fromItemStack).collect(Collectors.toList()));
    }

    public void setRenderers(List<Renderer> renderers) {
        this.renderers = renderers;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x - 1, this.y - 1, 18, 18);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.clickToMoreRecipes) {
            return false;
        }
        if (this.isCurrentRendererItem() && this.getBounds().contains(mouseX, mouseY)) {
            if (button == 0) {
                return ClientHelper.getInstance().executeRecipeKeyBind(this.getCurrentItemStack());
            }
            if (button == 1) {
                return ClientHelper.getInstance().executeUsageKeyBind(this.getCurrentItemStack());
            }
        }
        return false;
    }

    public boolean isCurrentRendererItem() {
        return this.getCurrentRenderer() instanceof ItemStackRenderer;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (!this.clickToMoreRecipes) {
            return false;
        }
        if (this.isCurrentRendererItem() && this.getBounds().contains(ClientUtils.getMouseLocation())) {
            if (ClientHelper.getInstance().getRecipeKeyBinding().method_1417(int_1, int_2)) {
                return ClientHelper.getInstance().executeRecipeKeyBind(this.getCurrentItemStack());
            }
            if (ClientHelper.getInstance().getUsageKeyBinding().method_1417(int_1, int_2)) {
                return ClientHelper.getInstance().executeUsageKeyBind(this.getCurrentItemStack());
            }
        }
        return false;
    }
}

