/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.utils;

import java.io.IOException;
import java.util.Optional;
import me.shedaniel.cloth.hooks.ScreenHooks;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListEntry;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ItemCheatingMode;
import me.shedaniel.rei.client.RecipeScreenType;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.config.ItemListOrderingConfig;
import me.shedaniel.rei.gui.credits.CreditsScreen;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ClothScreenRegistry {
    public static final String RESET = "text.cloth-config.reset_value";

    public static class_437 getConfigScreen(class_437 parent) {
        ConfigManager configManager = RoughlyEnoughItemsCore.getConfigManager();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle("text.rei.config.title").setSavingRunnable(() -> {
            try {
                configManager.saveConfig();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        ConfigEntryBuilder entryBuilder = ConfigEntryBuilder.create();
        ConfigCategory general = builder.getOrCreateCategory("text.rei.config.general");
        general.addEntry((AbstractConfigListEntry)new BooleanListEntry("text.rei.config.cheating", configManager.getConfig().cheating, RESET, () -> false, bool -> {
            configManager.getConfig().cheating = bool;
        }){

            public Optional<String[]> getTooltip() {
                String s = null;
                s = this.getValue() == false ? class_1074.method_4662((String)"text.rei.cheating_disabled", (Object[])new Object[0]) : (!RoughlyEnoughItemsCore.hasOperatorPermission() ? class_1074.method_4662((String)"text.rei.cheating_enabled_no_perms", (Object[])new Object[0]) : (RoughlyEnoughItemsCore.hasPermissionToUsePackets() ? class_1074.method_4662((String)"text.rei.cheating_enabled", (Object[])new Object[0]) : class_1074.method_4662((String)"text.rei.cheating_limited_enabled", (Object[])new Object[0])));
                return Optional.ofNullable(new String[]{s});
            }
        });
        ConfigCategory appearance = builder.getOrCreateCategory("text.rei.config.appearance");
        appearance.addEntry(entryBuilder.startBooleanToggle("text.rei.config.dark_theme", ScreenHelper.isDarkModeEnabled()).setDefaultValue(() -> false).setSaveConsumer(bool -> {
            configManager.getConfig().darkTheme = bool;
        }).setTooltipSupplier(() -> ClothScreenRegistry.getConfigTooltip("dark_theme", new Object[0])).buildEntry());
        appearance.addEntry((AbstractConfigListEntry)new EnumListEntry("text.rei.config.recipe_screen_type", RecipeScreenType.class, (Enum)configManager.getConfig().screenType, RESET, () -> RecipeScreenType.UNSET, bool -> {
            configManager.getConfig().screenType = bool;
        }, EnumListEntry.DEFAULT_NAME_PROVIDER, () -> ClothScreenRegistry.getConfigTooltip("recipe_screen_type", new Object[0])));
        appearance.addEntry(entryBuilder.startBooleanToggle("text.rei.config.side_search_box", configManager.getConfig().sideSearchField).setDefaultValue(() -> false).setSaveConsumer(bool -> {
            configManager.getConfig().sideSearchField = bool;
        }).setTooltipSupplier(() -> ClothScreenRegistry.getConfigTooltip("side_search_box", new Object[0])).buildEntry());
        appearance.addEntry((AbstractConfigListEntry)new EnumListEntry("text.rei.config.list_ordering", ItemListOrderingConfig.class, (Enum)ItemListOrderingConfig.from(configManager.getConfig().itemListOrdering, configManager.getConfig().isAscending), RESET, () -> ItemListOrderingConfig.REGISTRY_ASCENDING, config -> {
            configManager.getConfig().itemListOrdering = config.getOrdering();
            configManager.getConfig().isAscending = config.isAscending();
        }, EnumListEntry.DEFAULT_NAME_PROVIDER, () -> ClothScreenRegistry.getConfigTooltip("list_ordering", ItemListOrderingConfig.REGISTRY_ASCENDING.toString())));
        appearance.addEntry((AbstractConfigListEntry)new BooleanListEntry("text.rei.config.item_list_position", configManager.getConfig().mirrorItemPanel, RESET, () -> false, bool -> {
            configManager.getConfig().mirrorItemPanel = bool;
        }, () -> ClothScreenRegistry.getConfigTooltip("item_list_position", new Object[0])){

            public String getYesNoText(boolean bool) {
                return class_1074.method_4662((String)(bool ? "text.rei.config.item_list_position.left" : "text.rei.config.item_list_position.right"), (Object[])new Object[0]);
            }
        });
        appearance.addEntry((AbstractConfigListEntry)new IntegerSliderEntry("text.rei.config.max_recipes_per_page", 2, 99, configManager.getConfig().maxRecipePerPage, RESET, () -> 3, i -> {
            configManager.getConfig().maxRecipePerPage = i;
        }, () -> ClothScreenRegistry.getConfigTooltip("max_recipes_per_page", new Object[0])));
        appearance.addEntry((AbstractConfigListEntry)new BooleanListEntry("text.rei.config.light_gray_recipe_border", configManager.getConfig().lightGrayRecipeBorder, RESET, () -> false, bool -> {
            configManager.getConfig().lightGrayRecipeBorder = bool;
        }, () -> ClothScreenRegistry.getConfigTooltip("light_gray_recipe_border", new Object[0])));
        appearance.addEntry((AbstractConfigListEntry)new BooleanListEntry("text.rei.config.villager_screen_permanent_scroll_bar", configManager.getConfig().villagerScreenPermanentScrollBar, RESET, () -> false, bool -> {
            configManager.getConfig().villagerScreenPermanentScrollBar = bool;
        }, () -> ClothScreenRegistry.getConfigTooltip("villager_screen_permanent_scroll_bar", new Object[0])));
        ConfigCategory action = builder.getOrCreateCategory("text.rei.config.action");
        action.addEntry((AbstractConfigListEntry)new EnumListEntry("text.rei.config.item_cheating_mode", ItemCheatingMode.class, (Enum)configManager.getConfig().itemCheatingMode, RESET, () -> ItemCheatingMode.REI_LIKE, i -> {
            configManager.getConfig().itemCheatingMode = i;
        }, e -> class_1074.method_4662((String)("text.rei.config.item_cheating_mode." + e.name().toLowerCase()), (Object[])new Object[0]), () -> ClothScreenRegistry.getConfigTooltip("item_cheating_mode", new Object[0])));
        action.addEntry((AbstractConfigListEntry)new StringListEntry("text.rei.give_command", configManager.getConfig().giveCommand, RESET, () -> "/give {player_name} {item_identifier}{nbt} {count}", s -> {
            configManager.getConfig().giveCommand = s;
        }, () -> ClothScreenRegistry.getConfigTooltip("give_command", new Object[0])));
        action.addEntry((AbstractConfigListEntry)new StringListEntry("text.rei.gamemode_command", configManager.getConfig().gamemodeCommand, RESET, () -> "/gamemode {gamemode}", s -> {
            configManager.getConfig().gamemodeCommand = s;
        }, () -> ClothScreenRegistry.getConfigTooltip("gamemode_command", new Object[0])));
        action.addEntry((AbstractConfigListEntry)new StringListEntry("text.rei.weather_command", configManager.getConfig().weatherCommand, RESET, () -> "/weather {weather}", s -> {
            configManager.getConfig().weatherCommand = s;
        }, () -> ClothScreenRegistry.getConfigTooltip("weather_command", new Object[0])));
        action.addEntry((AbstractConfigListEntry)new BooleanListEntry("text.rei.config.register_in_other_thread", configManager.getConfig().registerRecipesInAnotherThread, RESET, () -> true, bool -> {
            configManager.getConfig().registerRecipesInAnotherThread = bool;
        }, () -> ClothScreenRegistry.getConfigTooltip("register_in_other_thread", new Object[0])));
        ConfigCategory modules = builder.getOrCreateCategory("text.rei.config.modules");
        modules.addEntry((AbstractConfigListEntry)new BooleanListEntry("text.rei.config.enable_craftable_only", configManager.getConfig().enableCraftableOnlyButton, RESET, () -> true, bool -> {
            configManager.getConfig().enableCraftableOnlyButton = bool;
        }, () -> ClothScreenRegistry.getConfigTooltip("enable_craftable_only", new Object[0])));
        modules.addEntry((AbstractConfigListEntry)new BooleanListEntry("text.rei.config.enable_util_buttons", configManager.getConfig().showUtilsButtons, RESET, () -> false, bool -> {
            configManager.getConfig().showUtilsButtons = bool;
        }, () -> ClothScreenRegistry.getConfigTooltip("enable_util_buttons", new Object[0])));
        modules.addEntry((AbstractConfigListEntry)new BooleanListEntry("text.rei.config.disable_recipe_book", configManager.getConfig().disableRecipeBook, RESET, () -> false, bool -> {
            configManager.getConfig().disableRecipeBook = bool;
        }, () -> ClothScreenRegistry.getConfigTooltip("disable_recipe_book", new Object[0])));
        return builder.setAfterInitConsumer(screen -> {
            class_4185 w = new class_4185(6, 6, 60, 20, class_1074.method_4662((String)"text.rei.credits", (Object[])new Object[0]), widget -> class_310.method_1551().method_1507((class_437)new CreditsScreen(class_310.method_1551().field_1755)));
            ((ScreenHooks)screen).cloth_getButtonWidgets().add(0, w);
            ((ScreenHooks)screen).cloth_getChildren().add(0, w);
        }).build();
    }

    private static Optional<String[]> getConfigTooltip(String s, Object ... o) {
        if (class_1074.method_4663((String)("tooltip.rei.config." + s))) {
            return Optional.ofNullable(class_1074.method_4662((String)("tooltip.rei.config." + s), (Object[])o).split("\n"));
        }
        return Optional.empty();
    }
}

