/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import me.shedaniel.cloth.api.ClientUtils;
import me.shedaniel.cloth.hooks.ClothClientHooks;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.ItemRegistry;
import me.shedaniel.rei.api.PluginDisabler;
import me.shedaniel.rei.api.REIPlugin;
import me.shedaniel.rei.api.REIPluginEntry;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.client.ConfigManagerImpl;
import me.shedaniel.rei.client.DisplayHelperImpl;
import me.shedaniel.rei.client.ItemRegistryImpl;
import me.shedaniel.rei.client.PluginDisablerImpl;
import me.shedaniel.rei.client.RecipeHelperImpl;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.ContainerScreenOverlay;
import me.shedaniel.rei.gui.widget.ItemListOverlay;
import me.shedaniel.rei.listeners.RecipeBookButtonWidgetHooks;
import me.shedaniel.rei.listeners.RecipeBookGuiHooks;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.Element;
import net.minecraft.client.gui.screen.ingame.AbstractContainerScreen;
import net.minecraft.client.gui.screen.ingame.CreativeInventoryScreen;
import net.minecraft.client.gui.screen.ingame.InventoryScreen;
import net.minecraft.client.gui.screen.recipebook.RecipeBookWidget;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.TexturedButtonWidget;
import net.minecraft.client.resource.language.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.text.LiteralText;
import net.minecraft.text.Text;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Identifier;
import net.minecraft.util.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoughlyEnoughItemsCore
implements ClientModInitializer {
    public static final Logger LOGGER;
    private static final RecipeHelper RECIPE_HELPER;
    private static final PluginDisabler PLUGIN_DISABLER;
    private static final ItemRegistry ITEM_REGISTRY;
    private static final DisplayHelper DISPLAY_HELPER;
    private static final Map<Identifier, REIPluginEntry> plugins;
    private static final ExecutorService SYNC_RECIPES;
    private static ConfigManagerImpl configManager;

    public static RecipeHelper getRecipeHelper() {
        return RECIPE_HELPER;
    }

    public static ConfigManager getConfigManager() {
        return configManager;
    }

    public static ItemRegistry getItemRegisterer() {
        return ITEM_REGISTRY;
    }

    public static PluginDisabler getPluginDisabler() {
        return PLUGIN_DISABLER;
    }

    public static DisplayHelper getDisplayHelper() {
        return DISPLAY_HELPER;
    }

    @Deprecated
    public static REIPluginEntry registerPlugin(Identifier identifier, REIPluginEntry plugin) {
        plugins.put(identifier, plugin);
        LOGGER.info("[REI] Registered plugin %s from %s", (Object)identifier.toString(), (Object)plugin.getClass().getSimpleName());
        plugin.onFirstLoad(RoughlyEnoughItemsCore.getPluginDisabler());
        return plugin;
    }

    public static List<REIPluginEntry> getPlugins() {
        return new LinkedList<REIPluginEntry>(plugins.values());
    }

    public static Optional<Identifier> getPluginIdentifier(REIPluginEntry plugin) {
        for (Identifier identifier : plugins.keySet()) {
            if (identifier == null || !plugins.get(identifier).equals(plugin)) continue;
            return Optional.of(identifier);
        }
        return Optional.empty();
    }

    public static boolean hasPermissionToUsePackets() {
        try {
            MinecraftClient.getInstance().getNetworkHandler().getCommandSource().hasPermissionLevel(0);
            return RoughlyEnoughItemsCore.hasOperatorPermission() && RoughlyEnoughItemsCore.canUsePackets();
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public static boolean hasOperatorPermission() {
        try {
            return MinecraftClient.getInstance().getNetworkHandler().getCommandSource().hasPermissionLevel(1);
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public static boolean canUsePackets() {
        return ClientSidePacketRegistry.INSTANCE.canServerReceive(RoughlyEnoughItemsNetwork.CREATE_ITEMS_PACKET) && ClientSidePacketRegistry.INSTANCE.canServerReceive(RoughlyEnoughItemsNetwork.DELETE_ITEMS_PACKET);
    }

    public void onInitializeClient() {
        configManager = new ConfigManagerImpl();
        this.registerClothEvents();
        this.discoverOldPlugins();
        this.discoverPluginEntries();
        ClientSidePacketRegistry.INSTANCE.register(RoughlyEnoughItemsNetwork.CREATE_ITEMS_MESSAGE_PACKET, (packetContext, packetByteBuf) -> {
            ItemStack stack = packetByteBuf.readItemStack().copy();
            String player = packetByteBuf.readString(Short.MAX_VALUE);
            packetContext.getPlayer().addChatMessage((Text)new LiteralText(I18n.translate((String)"text.rei.cheat_items", (Object[])new Object[0]).replaceAll("\\{item_name}", ItemListOverlay.tryGetItemStackName(stack)).replaceAll("\\{item_count}", stack.getCount() + "").replaceAll("\\{player_name}", player)), false);
        });
    }

    private void discoverPluginEntries() {
        for (REIPluginEntry reiPlugin : FabricLoader.getInstance().getEntrypoints("rei_plugins", REIPluginEntry.class)) {
            try {
                if (reiPlugin instanceof REIPlugin) {
                    throw new IllegalStateException("REI Plugins on Entry Points should not implement REIPlugin");
                }
                RoughlyEnoughItemsCore.registerPlugin(reiPlugin.getPluginIdentifier(), reiPlugin);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("[REI] Can't load REI plugins from %s: %s", reiPlugin.getClass(), (Object)e.getLocalizedMessage());
            }
        }
    }

    private void discoverOldPlugins() {
        ArrayList list = Lists.newArrayList();
        for (ModMetadata metadata2 : FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).filter(metadata -> metadata.containsCustomElement("roughlyenoughitems:plugins")).collect(Collectors.toList())) {
            LOGGER.warn("[REI] %s(%s) is still using the old way to register its plugin! Support will be dropped in the future!", (Object)metadata2.getName(), (Object)metadata2.getId());
            try {
                JsonElement pluginsElement = metadata2.getCustomElement("roughlyenoughitems:plugins");
                if (pluginsElement.isJsonArray()) {
                    for (JsonElement element : pluginsElement.getAsJsonArray()) {
                        if (element.isJsonObject()) {
                            this.loadPluginFromJsonObject(list, metadata2, element.getAsJsonObject());
                            continue;
                        }
                        throw new IllegalStateException("Custom Element in an array is not an object.");
                    }
                    continue;
                }
                if (pluginsElement.isJsonObject()) {
                    this.loadPluginFromJsonObject(list, metadata2, pluginsElement.getAsJsonObject());
                    continue;
                }
                throw new IllegalStateException("Custom Element not an array or an object.");
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error("[REI] Can't load REI plugins from %s: %s", (Object)metadata2.getId(), (Object)e.getLocalizedMessage());
            }
        }
        for (Pair pair : list) {
            String s = (String)pair.getRight();
            try {
                Class<?> aClass = Class.forName(s);
                if (!REIPlugin.class.isAssignableFrom(aClass)) {
                    LOGGER.error("[REI] Plugin class from %s is not implementing REIPlugin!", (Object)s);
                    break;
                }
                REIPlugin o = (REIPlugin)REIPlugin.class.cast(aClass.newInstance());
                RoughlyEnoughItemsCore.registerPlugin((Identifier)pair.getLeft(), o);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.error("[REI] Can't load REI plugin class from %s!", (Object)s);
            }
            catch (ClassCastException e) {
                LOGGER.error("[REI] Failed to cast plugin class from %s to REIPlugin!", (Object)s);
            }
        }
    }

    private void loadPluginFromJsonObject(List<Pair<Identifier, String>> list, ModMetadata modMetadata, JsonObject object) {
        String namespace = modMetadata.getId();
        if (object.has("namespace")) {
            namespace = object.get("namespace").getAsString();
        }
        String id = object.get("id").getAsString();
        String className = object.get("class").getAsString();
        list.add((Pair<Identifier, String>)new Pair((Object)new Identifier(namespace, id), (Object)className));
    }

    private void registerClothEvents() {
        Identifier recipeButtonTex = new Identifier("textures/gui/recipe_button.png");
        ClothClientHooks.SYNC_RECIPES.register((minecraftClient, recipeManager, synchronizeRecipesS2CPacket) -> {
            if (RoughlyEnoughItemsCore.getConfigManager().getConfig().registerRecipesInAnotherThread) {
                CompletableFuture.runAsync(() -> ((RecipeHelperImpl)RoughlyEnoughItemsCore.getRecipeHelper()).recipesLoaded(recipeManager), SYNC_RECIPES);
            } else {
                ((RecipeHelperImpl)RoughlyEnoughItemsCore.getRecipeHelper()).recipesLoaded(recipeManager);
            }
        });
        ClothClientHooks.SCREEN_ADD_BUTTON.register((minecraftClient, screen, abstractButtonWidget) -> {
            if (RoughlyEnoughItemsCore.getConfigManager().getConfig().disableRecipeBook && screen instanceof AbstractContainerScreen && abstractButtonWidget instanceof TexturedButtonWidget && ((RecipeBookButtonWidgetHooks)abstractButtonWidget).rei_getTexture().equals((Object)recipeButtonTex)) {
                return ActionResult.FAIL;
            }
            return ActionResult.PASS;
        });
        ClothClientHooks.SCREEN_INIT_POST.register((minecraftClient, screen, screenHooks) -> {
            if (screen instanceof AbstractContainerScreen) {
                if (screen instanceof InventoryScreen && minecraftClient.interactionManager.hasCreativeInventory()) {
                    return;
                }
                ScreenHelper.setLastContainerScreen((AbstractContainerScreen)screen);
                boolean alreadyAdded = false;
                for (Element element : Lists.newArrayList((Iterable)screenHooks.cloth_getInputListeners())) {
                    if (!ContainerScreenOverlay.class.isAssignableFrom(element.getClass())) continue;
                    if (alreadyAdded) {
                        screenHooks.cloth_getInputListeners().remove(element);
                        continue;
                    }
                    alreadyAdded = true;
                }
                if (!alreadyAdded) {
                    screenHooks.cloth_getInputListeners().add(ScreenHelper.getLastOverlay(true, false));
                }
            }
        });
        ClothClientHooks.SCREEN_RENDER_POST.register((minecraftClient, screen, i, i1, v) -> {
            if (screen instanceof AbstractContainerScreen) {
                ScreenHelper.getLastOverlay().render(i, i1, v);
            }
        });
        ClothClientHooks.SCREEN_MOUSE_CLICKED.register((minecraftClient, screen, v, v1, i) -> {
            if (screen instanceof CreativeInventoryScreen && ScreenHelper.isOverlayVisible() && ScreenHelper.getLastOverlay().mouseClicked(v, v1, i)) {
                screen.setFocused((Element)ScreenHelper.getLastOverlay());
                if (i == 0) {
                    screen.setDragging(true);
                }
                return ActionResult.SUCCESS;
            }
            return ActionResult.PASS;
        });
        ClothClientHooks.SCREEN_MOUSE_SCROLLED.register((minecraftClient, screen, v, v1, v2) -> {
            if (screen instanceof AbstractContainerScreen && ScreenHelper.isOverlayVisible() && ScreenHelper.getLastOverlay().isInside(ClientUtils.getMouseLocation()) && ScreenHelper.getLastOverlay().mouseScrolled(v, v1, v2)) {
                return ActionResult.SUCCESS;
            }
            return ActionResult.PASS;
        });
        ClothClientHooks.SCREEN_CHAR_TYPED.register((minecraftClient, screen, character, keyCode) -> {
            if (screen instanceof AbstractContainerScreen && ScreenHelper.getLastOverlay().charTyped(character, keyCode)) {
                return ActionResult.SUCCESS;
            }
            return ActionResult.PASS;
        });
        ClothClientHooks.SCREEN_LATE_RENDER.register((minecraftClient, screen, i, i1, v) -> {
            if (!ScreenHelper.isOverlayVisible()) {
                return;
            }
            if (screen instanceof AbstractContainerScreen) {
                ScreenHelper.getLastOverlay().lateRender(i, i1, v);
            }
        });
        ClothClientHooks.SCREEN_KEY_PRESSED.register((minecraftClient, screen, i, i1, i2) -> {
            if (screen.getFocused() != null && screen.getFocused() instanceof TextFieldWidget || screen.getFocused() instanceof RecipeBookWidget && ((RecipeBookGuiHooks)screen.getFocused()).rei_getSearchField() != null && ((RecipeBookGuiHooks)screen.getFocused()).rei_getSearchField().isFocused()) {
                return ActionResult.PASS;
            }
            if (screen instanceof AbstractContainerScreen && ScreenHelper.getLastOverlay().keyPressed(i, i1, i2)) {
                return ActionResult.SUCCESS;
            }
            return ActionResult.PASS;
        });
    }

    static {
        RECIPE_HELPER = new RecipeHelperImpl();
        PLUGIN_DISABLER = new PluginDisablerImpl();
        ITEM_REGISTRY = new ItemRegistryImpl();
        DISPLAY_HELPER = new DisplayHelperImpl();
        plugins = Maps.newHashMap();
        SYNC_RECIPES = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "REI-SyncRecipes"));
        LOGGER = LogManager.getFormatterLogger((String)"REI");
    }
}

