/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.rei.api.DisplaySettings;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.Renderable;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.renderables.RecipeRenderer;
import me.shedaniel.rei.gui.widget.CategoryBaseWidget;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import me.shedaniel.rei.gui.widget.Widget;
import net.minecraft.client.gui.DrawableHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Identifier;

public interface RecipeCategory<T extends RecipeDisplay> {
    public Identifier getIdentifier();

    @Deprecated
    default public ItemStack getCategoryIcon() {
        return ItemStack.EMPTY;
    }

    default public Renderer getIcon() {
        return Renderable.fromItemStackSupplier(this::getCategoryIcon);
    }

    public String getCategoryName();

    default public RecipeRenderer getSimpleRenderer(T recipe) {
        return Renderable.fromRecipe(() -> recipe.getInput(), () -> recipe.getOutput());
    }

    default public List<Widget> setupDisplay(Supplier<T> recipeDisplaySupplier, Rectangle bounds) {
        return Collections.singletonList(new RecipeBaseWidget(bounds));
    }

    default public void drawCategoryBackground(Rectangle bounds, int mouseX, int mouseY, float delta) {
        new CategoryBaseWidget(bounds).render();
        if (ScreenHelper.isDarkModeEnabled()) {
            DrawableHelper.fill((int)(bounds.x + 17), (int)(bounds.y + 5), (int)(bounds.x + bounds.width - 17), (int)(bounds.y + 17), (int)-12566464);
            DrawableHelper.fill((int)(bounds.x + 17), (int)(bounds.y + 21), (int)(bounds.x + bounds.width - 17), (int)(bounds.y + 33), (int)-12566464);
        } else {
            DrawableHelper.fill((int)(bounds.x + 17), (int)(bounds.y + 5), (int)(bounds.x + bounds.width - 17), (int)(bounds.y + 17), (int)-6381922);
            DrawableHelper.fill((int)(bounds.x + 17), (int)(bounds.y + 21), (int)(bounds.x + bounds.width - 17), (int)(bounds.y + 33), (int)-6381922);
        }
    }

    default public DisplaySettings getDisplaySettings() {
        return new DisplaySettings<T>(){

            @Override
            public int getDisplayHeight(RecipeCategory category) {
                return 66;
            }

            @Override
            public int getDisplayWidth(RecipeCategory category, T display) {
                return 150;
            }

            @Override
            public int getMaximumRecipePerPage(RecipeCategory category) {
                return 99;
            }
        };
    }

    default public int getDisplayHeight() {
        return RecipeHelper.getInstance().getCachedCategorySettings(this.getIdentifier()).map(settings -> settings.getDisplayHeight(this)).orElse(0);
    }

    default public int getDisplayWidth(T display) {
        return RecipeHelper.getInstance().getCachedCategorySettings(this.getIdentifier()).map(settings -> settings.getDisplayWidth(this, display)).orElse(0);
    }

    default public int getMaximumRecipePerPage() {
        return RecipeHelper.getInstance().getCachedCategorySettings(this.getIdentifier()).map(settings -> settings.getMaximumRecipePerPage(this)).orElse(0);
    }

    default public boolean checkTags() {
        return false;
    }
}

