/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.DisplaySettings;
import me.shedaniel.rei.api.DisplayVisibilityHandler;
import me.shedaniel.rei.api.LiveRecipeGenerator;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.SpeedCraftFunctional;
import net.minecraft.item.ItemStack;
import net.minecraft.recipe.Recipe;
import net.minecraft.recipe.RecipeManager;
import net.minecraft.util.Identifier;

public interface RecipeHelper {
    public static RecipeHelper getInstance() {
        return RoughlyEnoughItemsCore.getRecipeHelper();
    }

    public int getRecipeCount();

    public List<Recipe> getAllSortedRecipes();

    public List<ItemStack> findCraftableByItems(List<ItemStack> var1);

    public void registerCategory(RecipeCategory var1);

    public void registerWorkingStations(Identifier var1, List<ItemStack> ... var2);

    public void registerWorkingStations(Identifier var1, ItemStack ... var2);

    public List<List<ItemStack>> getWorkingStations(Identifier var1);

    public void registerDisplay(Identifier var1, RecipeDisplay var2);

    public Map<RecipeCategory, List<RecipeDisplay>> getRecipesFor(ItemStack var1);

    public RecipeManager getRecipeManager();

    public List<RecipeCategory> getAllCategories();

    public Map<RecipeCategory, List<RecipeDisplay>> getUsagesFor(ItemStack var1);

    public Optional<ButtonAreaSupplier> getSpeedCraftButtonArea(RecipeCategory var1);

    public void registerSpeedCraftButtonArea(Identifier var1, ButtonAreaSupplier var2);

    @Deprecated
    public void registerDefaultSpeedCraftButtonArea(Identifier var1);

    public List<SpeedCraftFunctional> getSpeedCraftFunctional(RecipeCategory var1);

    public void registerSpeedCraftFunctional(Identifier var1, SpeedCraftFunctional var2);

    public Map<RecipeCategory, List<RecipeDisplay>> getAllRecipes();

    public void registerRecipeVisibilityHandler(DisplayVisibilityHandler var1);

    public void unregisterRecipeVisibilityHandler(DisplayVisibilityHandler var1);

    public List<DisplayVisibilityHandler> getDisplayVisibilityHandlers();

    @Deprecated
    public boolean isDisplayVisible(RecipeDisplay var1, boolean var2);

    public boolean isDisplayVisible(RecipeDisplay var1);

    public <T extends Recipe<?>> void registerRecipes(Identifier var1, Predicate<Recipe> var2, Function<T, RecipeDisplay> var3);

    public Optional<DisplaySettings> getCachedCategorySettings(Identifier var1);

    public void registerLiveRecipeGenerator(LiveRecipeGenerator var1);

    public <T extends Recipe<?>> void registerRecipes(Identifier var1, Class<T> var2, Function<T, RecipeDisplay> var3);

    public <T extends Recipe<?>> void registerRecipes(Identifier var1, Function<Recipe, Boolean> var2, Function<T, RecipeDisplay> var3);
}

