/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api;

import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.rei.gui.renderables.EmptyRenderer;
import me.shedaniel.rei.gui.renderables.ItemStackRenderer;
import me.shedaniel.rei.gui.renderables.SimpleRecipeRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public interface Renderable {
    public static ItemStackRenderer fromItemStackSupplier(final Supplier<ItemStack> supplier) {
        return new ItemStackRenderer(){

            @Override
            public ItemStack getItemStack() {
                return (ItemStack)supplier.get();
            }
        };
    }

    public static ItemStackRenderer fromItemStack(ItemStack stack) {
        return Renderable.fromItemStackSupplier(() -> stack);
    }

    public static EmptyRenderer empty() {
        return EmptyRenderer.INSTANCE;
    }

    public static SimpleRecipeRenderer fromRecipe(Supplier<List<List<ItemStack>>> input, Supplier<List<ItemStack>> output) {
        return new SimpleRecipeRenderer(input, output);
    }

    public static ItemStackRenderer fromItemStacks(final List<ItemStack> stacks) {
        return new ItemStackRenderer(){

            @Override
            public ItemStack getItemStack() {
                if (stacks.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                return (ItemStack)stacks.get(MathHelper.floor((double)((double)(System.currentTimeMillis() / 500L) % (double)stacks.size() / 1.0)));
            }
        };
    }

    public void render(int var1, int var2, double var3, double var5, float var7);
}

