/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Pair;

public class BaseBoundsHandlerImpl
implements BaseBoundsHandler {
    private static final Function<Rectangle, String> RECTANGLE_STRING_FUNCTION = rectangle -> rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
    private static final Comparator<Rectangle> RECTANGLE_COMPARATOR = BaseBoundsHandlerImpl::compare;
    private static final Comparator<Pair<Pair<Class<? extends Screen>, Float>, BaseBoundsHandler.ExclusionZoneSupplier>> LIST_PAIR_COMPARATOR;
    private String lastArea = null;
    private List<Pair<Pair<Class<? extends Screen>, Float>, BaseBoundsHandler.ExclusionZoneSupplier>> list = Lists.newArrayList();

    private static int compare(Rectangle o1, Rectangle o2) {
        return RECTANGLE_STRING_FUNCTION.apply(o1).compareTo(RECTANGLE_STRING_FUNCTION.apply(o2));
    }

    @Override
    public Class getBaseSupportedClass() {
        return Screen.class;
    }

    @Override
    public Rectangle getLeftBounds(Screen screen) {
        return new Rectangle();
    }

    @Override
    public Rectangle getRightBounds(Screen screen) {
        return new Rectangle();
    }

    @Override
    public float getPriority() {
        return -5.0f;
    }

    @Override
    public ActionResult isInZone(boolean isOnRightSide, double mouseX, double mouseY) {
        for (Rectangle zone : this.getCurrentExclusionZones(MinecraftClient.getInstance().currentScreen.getClass(), isOnRightSide)) {
            if (!zone.contains(mouseX, mouseY)) continue;
            return ActionResult.FAIL;
        }
        return ActionResult.PASS;
    }

    @Override
    public boolean shouldRecalculateArea(boolean isOnRightSide, Rectangle rectangle) {
        if (this.lastArea == null) {
            this.lastArea = this.getStringFromCurrent(isOnRightSide);
            return false;
        }
        if (this.lastArea.contentEquals(this.getStringFromCurrent(isOnRightSide))) {
            return false;
        }
        this.lastArea = this.getStringFromCurrent(isOnRightSide);
        return true;
    }

    private DisplayHelper.DisplayBoundsHandler getHandler() {
        return RoughlyEnoughItemsCore.getDisplayHelper().getResponsibleBoundsHandler(MinecraftClient.getInstance().currentScreen.getClass());
    }

    private String getStringFromCurrent(boolean isOnRightSide) {
        return this.getStringFromAreas(isOnRightSide ? this.getHandler().getRightBounds(MinecraftClient.getInstance().currentScreen) : this.getHandler().getLeftBounds(MinecraftClient.getInstance().currentScreen), this.getCurrentExclusionZones(MinecraftClient.getInstance().currentScreen.getClass(), isOnRightSide));
    }

    @Override
    public ActionResult canItemSlotWidgetFit(boolean isOnRightSide, int left, int top, Screen screen, Rectangle fullBounds) {
        List<Rectangle> currentExclusionZones = this.getCurrentExclusionZones(MinecraftClient.getInstance().currentScreen.getClass(), isOnRightSide);
        for (Rectangle currentExclusionZone : currentExclusionZones) {
            if (left + 18 < currentExclusionZone.x || top + 18 < currentExclusionZone.y || left > currentExclusionZone.x + currentExclusionZone.width || top > currentExclusionZone.y + currentExclusionZone.height) continue;
            return ActionResult.FAIL;
        }
        return ActionResult.PASS;
    }

    @Override
    public List<Rectangle> getCurrentExclusionZones(Class<? extends Screen> currentScreenClass, boolean isOnRightSide) {
        List<Pair> only = this.list.stream().filter(pair -> ((Class)((Pair)pair.getLeft()).getLeft()).isAssignableFrom(currentScreenClass)).collect(Collectors.toList());
        only.sort(LIST_PAIR_COMPARATOR);
        ArrayList rectangles = Lists.newArrayList();
        only.forEach(pair -> rectangles.addAll(((BaseBoundsHandler.ExclusionZoneSupplier)pair.getRight()).apply(isOnRightSide)));
        return rectangles;
    }

    @Override
    public void registerExclusionZones(Class<? extends Screen> screenClass, BaseBoundsHandler.ExclusionZoneSupplier supplier) {
        this.list.add((Pair<Pair<Class<? extends Screen>, Float>, BaseBoundsHandler.ExclusionZoneSupplier>)new Pair((Object)new Pair(screenClass, (Object)Float.valueOf(0.0f)), (Object)supplier));
    }

    public String getStringFromAreas(Rectangle rectangle, List<Rectangle> exclusionZones) {
        ArrayList sorted = Lists.newArrayList(exclusionZones);
        sorted.sort(RECTANGLE_COMPARATOR);
        return RECTANGLE_STRING_FUNCTION.apply(rectangle) + ":" + sorted.stream().map(RECTANGLE_STRING_FUNCTION::apply).collect(Collectors.joining("|"));
    }

    static {
        Comparator<Pair> comparator = Comparator.comparingDouble(value -> ((Float)((Pair)value.getLeft()).getRight()).floatValue());
        LIST_PAIR_COMPARATOR = comparator.reversed();
    }
}

