/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.client.RecipeScreenType;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.PreRecipeViewingScreen;
import me.shedaniel.rei.gui.RecipeViewingScreen;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.keybinding.FabricKeyBinding;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.fabricmc.fabric.impl.client.keybinding.KeyBindingRegistryImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.ingame.CreativeInventoryScreen;
import net.minecraft.client.util.InputUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.text.Text;
import net.minecraft.text.TranslatableText;
import net.minecraft.util.Formatting;
import net.minecraft.util.Identifier;
import net.minecraft.util.PacketByteBuf;
import net.minecraft.util.registry.Registry;

public class ClientHelperImpl
implements ClientHelper,
ClientModInitializer {
    public static ClientHelperImpl instance;
    private final Identifier recipeKeybind = new Identifier("roughlyenoughitems", "recipe_keybind");
    private final Identifier usageKeybind = new Identifier("roughlyenoughitems", "usage_keybind");
    private final Identifier hideKeybind = new Identifier("roughlyenoughitems", "hide_keybind");
    private final Identifier previousPageKeybind = new Identifier("roughlyenoughitems", "previous_page");
    private final Identifier nextPageKeybind = new Identifier("roughlyenoughitems", "next_page");
    private final Map<String, String> modNameCache = Maps.newHashMap();
    public FabricKeyBinding recipe;
    public FabricKeyBinding usage;
    public FabricKeyBinding hide;
    public FabricKeyBinding previousPage;
    public FabricKeyBinding nextPage;

    public String getFormattedModNoItalicFromItem(Item item) {
        String mod = this.getModFromItem(item);
        if (mod.equalsIgnoreCase("")) {
            return "";
        }
        return Formatting.BLUE.toString() + mod;
    }

    @Override
    public String getFormattedModFromItem(Item item) {
        String mod = this.getModFromItem(item);
        if (mod.equalsIgnoreCase("")) {
            return "";
        }
        return Formatting.BLUE.toString() + Formatting.ITALIC.toString() + mod;
    }

    @Override
    public String getFormattedModFromIdentifier(Identifier identifier) {
        String mod = this.getModFromIdentifier(identifier);
        if (mod.equalsIgnoreCase("")) {
            return "";
        }
        return Formatting.BLUE.toString() + Formatting.ITALIC.toString() + mod;
    }

    @Override
    public FabricKeyBinding getRecipeKeyBinding() {
        return this.recipe;
    }

    @Override
    public FabricKeyBinding getUsageKeyBinding() {
        return this.usage;
    }

    @Override
    public FabricKeyBinding getHideKeyBinding() {
        return this.hide;
    }

    @Override
    public FabricKeyBinding getPreviousPageKeyBinding() {
        return this.previousPage;
    }

    @Override
    public FabricKeyBinding getNextPageKeyBinding() {
        return this.nextPage;
    }

    @Override
    public String getModFromItem(Item item) {
        if (item.equals(Items.AIR)) {
            return "";
        }
        return this.getModFromIdentifier(Registry.ITEM.getId((Object)item));
    }

    @Override
    public String getModFromIdentifier(Identifier identifier) {
        if (identifier == null) {
            return "";
        }
        Optional<Object> any = Optional.ofNullable(this.modNameCache.getOrDefault(identifier.getNamespace(), null));
        if (any.isPresent()) {
            return any.get();
        }
        String modid = identifier.getNamespace();
        String s = FabricLoader.getInstance().getModContainer(modid).map(ModContainer::getMetadata).map(ModMetadata::getName).orElse(modid);
        this.modNameCache.put(modid, s);
        return s;
    }

    @Override
    public boolean isCheating() {
        return RoughlyEnoughItemsCore.getConfigManager().getConfig().cheating;
    }

    @Override
    public void setCheating(boolean cheating) {
        RoughlyEnoughItemsCore.getConfigManager().getConfig().cheating = cheating;
        try {
            RoughlyEnoughItemsCore.getConfigManager().saveConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendDeletePacket() {
        if (ScreenHelper.getLastContainerScreen() instanceof CreativeInventoryScreen) {
            MinecraftClient.getInstance().player.inventory.setCursorStack(ItemStack.EMPTY);
            return;
        }
        ClientSidePacketRegistry.INSTANCE.sendToServer(RoughlyEnoughItemsNetwork.DELETE_ITEMS_PACKET, new PacketByteBuf(Unpooled.buffer()));
    }

    @Override
    public boolean tryCheatingStack(ItemStack cheatedStack) {
        if (RoughlyEnoughItemsCore.canUsePackets()) {
            try {
                ClientSidePacketRegistry.INSTANCE.sendToServer(RoughlyEnoughItemsNetwork.CREATE_ITEMS_PACKET, new PacketByteBuf(Unpooled.buffer()).writeItemStack(cheatedStack.copy()));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        Identifier identifier = Registry.ITEM.getId((Object)cheatedStack.getItem());
        String tagMessage = cheatedStack.copy().getTag() != null && !cheatedStack.copy().getTag().isEmpty() ? cheatedStack.copy().getTag().asString() : "";
        String og = cheatedStack.getCount() == 1 ? RoughlyEnoughItemsCore.getConfigManager().getConfig().giveCommand.replaceAll(" \\{count}", "") : RoughlyEnoughItemsCore.getConfigManager().getConfig().giveCommand;
        String madeUpCommand = og.replaceAll("\\{player_name}", MinecraftClient.getInstance().player.getEntityName()).replaceAll("\\{item_name}", identifier.getPath()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", tagMessage).replaceAll("\\{count}", String.valueOf(cheatedStack.getCount()));
        if (madeUpCommand.length() > 256) {
            madeUpCommand = og.replaceAll("\\{player_name}", MinecraftClient.getInstance().player.getEntityName()).replaceAll("\\{item_name}", identifier.getPath()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", "").replaceAll("\\{count}", String.valueOf(cheatedStack.getCount()));
            MinecraftClient.getInstance().player.addChatMessage((Text)new TranslatableText("text.rei.too_long_nbt", new Object[0]), false);
        }
        MinecraftClient.getInstance().player.sendChatMessage(madeUpCommand);
        return true;
    }

    @Override
    public boolean executeRecipeKeyBind(ItemStack stack) {
        Map<RecipeCategory, List<RecipeDisplay>> map = RecipeHelper.getInstance().getRecipesFor(stack);
        if (map.keySet().size() > 0) {
            this.openRecipeViewingScreen(map);
        }
        return map.keySet().size() > 0;
    }

    @Override
    public boolean executeUsageKeyBind(ItemStack stack) {
        Map<RecipeCategory, List<RecipeDisplay>> map = RecipeHelper.getInstance().getUsagesFor(stack);
        if (map.keySet().size() > 0) {
            this.openRecipeViewingScreen(map);
        }
        return map.keySet().size() > 0;
    }

    @Override
    public List<ItemStack> getInventoryItemsTypes() {
        ImmutableList field_7543 = ImmutableList.of((Object)MinecraftClient.getInstance().player.inventory.main, (Object)MinecraftClient.getInstance().player.inventory.armor, (Object)MinecraftClient.getInstance().player.inventory.offHand);
        ArrayList<ItemStack> inventoryStacks = new ArrayList<ItemStack>();
        field_7543.forEach(itemStacks -> itemStacks.forEach(itemStack -> {
            if (!itemStack.isEmpty()) {
                inventoryStacks.add((ItemStack)itemStack);
            }
        }));
        return inventoryStacks;
    }

    @Override
    public boolean executeViewAllRecipesKeyBind() {
        Map<RecipeCategory, List<RecipeDisplay>> map = RecipeHelper.getInstance().getAllRecipes();
        if (map.keySet().size() > 0) {
            this.openRecipeViewingScreen(map);
        }
        return map.keySet().size() > 0;
    }

    @Override
    public void openRecipeViewingScreen(Map<RecipeCategory, List<RecipeDisplay>> map) {
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().screenType == RecipeScreenType.VILLAGER) {
            MinecraftClient.getInstance().openScreen((Screen)new VillagerRecipeViewingScreen(map));
        } else if (RoughlyEnoughItemsCore.getConfigManager().getConfig().screenType == RecipeScreenType.UNSET) {
            MinecraftClient.getInstance().openScreen((Screen)new PreRecipeViewingScreen(map));
        } else {
            MinecraftClient.getInstance().openScreen((Screen)new RecipeViewingScreen(map));
        }
    }

    public void onInitializeClient() {
        instance = this;
        this.registerFabricKeyBinds();
        this.modNameCache.put("minecraft", "Minecraft");
        this.modNameCache.put("c", "Common");
    }

    @Override
    public void registerFabricKeyBinds() {
        String category = "key.rei.category";
        KeyBindingRegistryImpl.INSTANCE.addCategory(category);
        this.recipe = FabricKeyBinding.Builder.create((Identifier)this.recipeKeybind, (InputUtil.Type)InputUtil.Type.KEYSYM, (int)82, (String)category).build();
        KeyBindingRegistryImpl.INSTANCE.register(this.recipe);
        this.usage = FabricKeyBinding.Builder.create((Identifier)this.usageKeybind, (InputUtil.Type)InputUtil.Type.KEYSYM, (int)85, (String)category).build();
        KeyBindingRegistryImpl.INSTANCE.register(this.usage);
        this.hide = FabricKeyBinding.Builder.create((Identifier)this.hideKeybind, (InputUtil.Type)InputUtil.Type.KEYSYM, (int)79, (String)category).build();
        KeyBindingRegistryImpl.INSTANCE.register(this.hide);
        this.previousPage = FabricKeyBinding.Builder.create((Identifier)this.previousPageKeybind, (InputUtil.Type)InputUtil.Type.KEYSYM, (int)-1, (String)category).build();
        KeyBindingRegistryImpl.INSTANCE.register(this.previousPage);
        this.nextPage = FabricKeyBinding.Builder.create((Identifier)this.nextPageKeybind, (InputUtil.Type)InputUtil.Type.KEYSYM, (int)-1, (String)category).build();
        KeyBindingRegistryImpl.INSTANCE.register(this.nextPage);
    }
}

