/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.ItemRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DefaultedList;

public class ItemRegistryImpl
implements ItemRegistry {
    private final CopyOnWriteArrayList<ItemStack> itemList = Lists.newCopyOnWriteArrayList();

    @Override
    public List<ItemStack> getItemList() {
        return Collections.unmodifiableList(this.itemList);
    }

    @Override
    public List<ItemStack> getModifiableItemList() {
        return this.itemList;
    }

    @Override
    public ItemStack[] getAllStacksFromItem(Item item) {
        DefaultedList list = DefaultedList.create();
        list.add((Object)item.getStackForRender());
        item.appendStacks(item.getGroup(), list);
        TreeSet stackSet = list.stream().collect(Collectors.toCollection(() -> new TreeSet((p1, p2) -> ItemStack.areEqualIgnoreDamage((ItemStack)p1, (ItemStack)p2) ? 0 : 1)));
        return Lists.newArrayList((Iterable)stackSet).toArray(new ItemStack[0]);
    }

    @Override
    public void registerItemStack(Item afterItem, ItemStack stack) {
        if (!stack.isEmpty() && !this.alreadyContain(stack)) {
            if (afterItem == null || afterItem.equals(Items.AIR)) {
                this.itemList.add(stack);
            } else {
                int last = this.itemList.size();
                for (int i = 0; i < this.itemList.size(); ++i) {
                    if (!this.itemList.get(i).getItem().equals(afterItem)) continue;
                    last = i + 1;
                }
                this.itemList.add(last, stack);
            }
        }
    }
}

