/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.DisplaySettings;
import me.shedaniel.rei.api.DisplayVisibility;
import me.shedaniel.rei.api.DisplayVisibilityHandler;
import me.shedaniel.rei.api.LiveRecipeGenerator;
import me.shedaniel.rei.api.PluginDisabler;
import me.shedaniel.rei.api.PluginFunction;
import me.shedaniel.rei.api.REIPluginEntry;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.SpeedCraftFunctional;
import me.shedaniel.rei.client.BaseBoundsHandlerImpl;
import me.shedaniel.rei.client.DisplayHelperImpl;
import me.shedaniel.rei.client.ScreenHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.recipe.Recipe;
import net.minecraft.recipe.RecipeManager;
import net.minecraft.util.Identifier;

public class RecipeHelperImpl
implements RecipeHelper {
    private static final Comparator<DisplayVisibilityHandler> VISIBILITY_HANDLER_COMPARATOR;
    private static final Comparator<Recipe> RECIPE_COMPARATOR;
    public final List<RecipeFunction> recipeFunctions = Lists.newArrayList();
    private final AtomicInteger recipeCount = new AtomicInteger();
    private final Map<Identifier, List<RecipeDisplay>> recipeCategoryListMap = Maps.newHashMap();
    private final Map<Identifier, DisplaySettings> categoryDisplaySettingsMap = Maps.newHashMap();
    private final List<RecipeCategory> categories = Lists.newArrayList();
    private final Map<Identifier, ButtonAreaSupplier> speedCraftAreaSupplierMap = Maps.newHashMap();
    private final Map<Identifier, List<SpeedCraftFunctional>> speedCraftFunctionalMap = Maps.newHashMap();
    private final Map<Identifier, List<List<ItemStack>>> categoryWorkingStations = Maps.newHashMap();
    private final List<DisplayVisibilityHandler> displayVisibilityHandlers = Lists.newArrayList();
    private final List<LiveRecipeGenerator> liveRecipeGenerators = Lists.newArrayList();
    private RecipeManager recipeManager;

    @Override
    public List<ItemStack> findCraftableByItems(List<ItemStack> inventoryItems) {
        ArrayList<ItemStack> craftables = new ArrayList<ItemStack>();
        for (List<RecipeDisplay> value : this.recipeCategoryListMap.values()) {
            for (RecipeDisplay recipeDisplay : value) {
                int slotsCraftable = 0;
                List<List<ItemStack>> requiredInput = recipeDisplay.getRequiredItems();
                block2: for (List<ItemStack> slot : requiredInput) {
                    if (slot.isEmpty()) {
                        ++slotsCraftable;
                        continue;
                    }
                    boolean slotDone = false;
                    for (ItemStack possibleType : inventoryItems) {
                        for (ItemStack slotPossible : slot) {
                            if (!ItemStack.areItemsEqualIgnoreDamage((ItemStack)slotPossible, (ItemStack)possibleType)) continue;
                            ++slotsCraftable;
                            slotDone = true;
                            break;
                        }
                        if (!slotDone) continue;
                        continue block2;
                    }
                }
                if (slotsCraftable != recipeDisplay.getRequiredItems().size()) continue;
                craftables.addAll(recipeDisplay.getOutput());
            }
        }
        return craftables.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public void registerCategory(RecipeCategory category) {
        this.categories.add(category);
        this.categoryDisplaySettingsMap.put(category.getIdentifier(), category.getDisplaySettings());
        this.recipeCategoryListMap.put(category.getIdentifier(), Lists.newLinkedList());
        this.categoryWorkingStations.put(category.getIdentifier(), Lists.newLinkedList());
    }

    @Override
    public void registerWorkingStations(Identifier category, List<ItemStack> ... workingStations) {
        this.categoryWorkingStations.get(category).addAll(Arrays.asList(workingStations));
    }

    @Override
    public void registerWorkingStations(Identifier category, ItemStack ... workingStations) {
        this.categoryWorkingStations.get(category).addAll(Arrays.asList(workingStations).stream().map(Collections::singletonList).collect(Collectors.toList()));
    }

    @Override
    public List<List<ItemStack>> getWorkingStations(Identifier category) {
        return this.categoryWorkingStations.get(category);
    }

    @Override
    public void registerDisplay(Identifier categoryIdentifier, RecipeDisplay display) {
        if (!this.recipeCategoryListMap.containsKey(categoryIdentifier)) {
            return;
        }
        this.recipeCount.incrementAndGet();
        this.recipeCategoryListMap.get(categoryIdentifier).add(display);
    }

    private void registerDisplay(Identifier categoryIdentifier, RecipeDisplay display, int index) {
        if (!this.recipeCategoryListMap.containsKey(categoryIdentifier)) {
            return;
        }
        this.recipeCount.incrementAndGet();
        this.recipeCategoryListMap.get(categoryIdentifier).add(index, display);
    }

    @Override
    public Map<RecipeCategory, List<RecipeDisplay>> getRecipesFor(ItemStack stack) {
        HashMap categoriesMap = new HashMap();
        this.categories.forEach(f -> {
            List cfr_ignored_0 = categoriesMap.put(f.getIdentifier(), Lists.newArrayList());
        });
        for (Map.Entry<Identifier, List<RecipeDisplay>> entry : this.recipeCategoryListMap.entrySet()) {
            RecipeCategory category2 = this.getCategory(entry.getKey());
            for (RecipeDisplay recipeDisplay : entry.getValue()) {
                for (ItemStack outputStack : recipeDisplay.getOutput()) {
                    if (!(category2.checkTags() ? ItemStack.areEqualIgnoreDamage((ItemStack)stack, (ItemStack)outputStack) : ItemStack.areItemsEqualIgnoreDamage((ItemStack)stack, (ItemStack)outputStack))) continue;
                    ((List)categoriesMap.get(recipeDisplay.getRecipeCategory())).add(recipeDisplay);
                }
            }
        }
        for (LiveRecipeGenerator liveRecipeGenerator : this.liveRecipeGenerators) {
            liveRecipeGenerator.getRecipeFor(stack).ifPresent(o -> ((List)categoriesMap.get(liveRecipeGenerator.getCategoryIdentifier())).addAll(o));
        }
        LinkedHashMap recipeCategoryListMap = Maps.newLinkedHashMap();
        this.categories.forEach(category -> {
            if (categoriesMap.containsKey(category.getIdentifier()) && !((List)categoriesMap.get(category.getIdentifier())).isEmpty()) {
                recipeCategoryListMap.put(category, ((List)categoriesMap.get(category.getIdentifier())).stream().filter(display -> this.isDisplayVisible((RecipeDisplay)display)).collect(Collectors.toList()));
            }
        });
        for (RecipeCategory category2 : Lists.newArrayList(recipeCategoryListMap.keySet())) {
            if (!((List)recipeCategoryListMap.get(category2)).isEmpty()) continue;
            recipeCategoryListMap.remove(category2);
        }
        return recipeCategoryListMap;
    }

    private RecipeCategory getCategory(Identifier identifier) {
        return this.categories.stream().filter(category -> category.getIdentifier().equals((Object)identifier)).findFirst().orElse(null);
    }

    @Override
    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    @Override
    public Map<RecipeCategory, List<RecipeDisplay>> getUsagesFor(ItemStack stack) {
        HashMap categoriesMap = new HashMap();
        this.categories.forEach(f -> {
            List cfr_ignored_0 = categoriesMap.put(f.getIdentifier(), Lists.newArrayList());
        });
        for (Map.Entry<Identifier, List<RecipeDisplay>> entry : this.recipeCategoryListMap.entrySet()) {
            RecipeCategory category2 = this.getCategory(entry.getKey());
            block1: for (RecipeDisplay recipeDisplay : entry.getValue()) {
                boolean found = false;
                for (List<ItemStack> input : recipeDisplay.getInput()) {
                    for (ItemStack itemStack : input) {
                        if (!(category2.checkTags() ? ItemStack.areEqualIgnoreDamage((ItemStack)itemStack, (ItemStack)stack) : ItemStack.areItemsEqualIgnoreDamage((ItemStack)itemStack, (ItemStack)stack))) continue;
                        ((List)categoriesMap.get(recipeDisplay.getRecipeCategory())).add(recipeDisplay);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    continue block1;
                }
            }
        }
        for (LiveRecipeGenerator liveRecipeGenerator : this.liveRecipeGenerators) {
            liveRecipeGenerator.getUsageFor(stack).ifPresent(o -> ((List)categoriesMap.get(liveRecipeGenerator.getCategoryIdentifier())).addAll(o));
        }
        LinkedHashMap recipeCategoryListMap = Maps.newLinkedHashMap();
        this.categories.forEach(category -> {
            if (categoriesMap.containsKey(category.getIdentifier()) && !((List)categoriesMap.get(category.getIdentifier())).isEmpty()) {
                recipeCategoryListMap.put(category, ((List)categoriesMap.get(category.getIdentifier())).stream().filter(display -> this.isDisplayVisible((RecipeDisplay)display)).collect(Collectors.toList()));
            }
        });
        for (RecipeCategory category2 : Lists.newArrayList(recipeCategoryListMap.keySet())) {
            if (!((List)recipeCategoryListMap.get(category2)).isEmpty()) continue;
            recipeCategoryListMap.remove(category2);
        }
        return recipeCategoryListMap;
    }

    @Override
    public List<RecipeCategory> getAllCategories() {
        return new LinkedList<RecipeCategory>(this.categories);
    }

    @Override
    public Optional<ButtonAreaSupplier> getSpeedCraftButtonArea(RecipeCategory category) {
        if (!this.speedCraftAreaSupplierMap.containsKey(category.getIdentifier())) {
            return Optional.ofNullable(bounds -> new Rectangle((int)bounds.getMaxX() - 16, (int)bounds.getMaxY() - 16, 10, 10));
        }
        return Optional.ofNullable(this.speedCraftAreaSupplierMap.get(category.getIdentifier()));
    }

    @Override
    public void registerSpeedCraftButtonArea(Identifier category, ButtonAreaSupplier rectangle) {
        if (rectangle == null) {
            if (this.speedCraftAreaSupplierMap.containsKey(category)) {
                this.speedCraftAreaSupplierMap.remove(category);
            }
        } else {
            this.speedCraftAreaSupplierMap.put(category, rectangle);
        }
    }

    @Override
    public void registerDefaultSpeedCraftButtonArea(Identifier category) {
        this.registerSpeedCraftButtonArea(category, bounds -> new Rectangle((int)bounds.getMaxX() - 16, (int)bounds.getMaxY() - 16, 10, 10));
    }

    @Override
    public List<SpeedCraftFunctional> getSpeedCraftFunctional(RecipeCategory category) {
        if (this.speedCraftFunctionalMap.get(category.getIdentifier()) == null) {
            return Lists.newArrayList();
        }
        return this.speedCraftFunctionalMap.get(category.getIdentifier());
    }

    @Override
    public void registerSpeedCraftFunctional(Identifier category, SpeedCraftFunctional functional) {
        LinkedList list = this.speedCraftFunctionalMap.containsKey(category) ? new LinkedList(this.speedCraftFunctionalMap.get(category)) : Lists.newLinkedList();
        list.add(functional);
        this.speedCraftFunctionalMap.put(category, list);
    }

    public void recipesLoaded(RecipeManager recipeManager) {
        this.recipeCount.set(0);
        this.recipeManager = recipeManager;
        this.recipeCategoryListMap.clear();
        this.categories.clear();
        this.speedCraftAreaSupplierMap.clear();
        this.categoryWorkingStations.clear();
        this.speedCraftFunctionalMap.clear();
        this.categoryDisplaySettingsMap.clear();
        this.recipeFunctions.clear();
        this.displayVisibilityHandlers.clear();
        this.liveRecipeGenerators.clear();
        ((DisplayHelperImpl)RoughlyEnoughItemsCore.getDisplayHelper()).resetCache();
        BaseBoundsHandlerImpl baseBoundsHandler = new BaseBoundsHandlerImpl();
        RoughlyEnoughItemsCore.getDisplayHelper().registerBoundsHandler(baseBoundsHandler);
        ((DisplayHelperImpl)RoughlyEnoughItemsCore.getDisplayHelper()).setBaseBoundsHandler(baseBoundsHandler);
        long startTime = System.currentTimeMillis();
        LinkedList<REIPluginEntry> plugins = new LinkedList<REIPluginEntry>(RoughlyEnoughItemsCore.getPlugins());
        plugins.sort((first, second) -> second.getPriority() - first.getPriority());
        RoughlyEnoughItemsCore.LOGGER.info("[REI] Loading %d plugins: %s", (Object)plugins.size(), (Object)plugins.stream().map(REIPluginEntry::getPluginIdentifier).map(Identifier::toString).collect(Collectors.joining(", ")));
        Collections.reverse(plugins);
        RoughlyEnoughItemsCore.getItemRegisterer().getModifiableItemList().clear();
        PluginDisabler pluginDisabler = RoughlyEnoughItemsCore.getPluginDisabler();
        plugins.forEach(plugin -> {
            Identifier identifier = plugin.getPluginIdentifier();
            try {
                if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_ITEMS)) {
                    plugin.registerItems(RoughlyEnoughItemsCore.getItemRegisterer());
                }
                if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_CATEGORIES)) {
                    plugin.registerPluginCategories(this);
                }
                if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_RECIPE_DISPLAYS)) {
                    plugin.registerRecipeDisplays(this);
                }
                if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_BOUNDS)) {
                    plugin.registerBounds(RoughlyEnoughItemsCore.getDisplayHelper());
                }
                if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_OTHERS)) {
                    plugin.registerOthers(this);
                }
            }
            catch (Exception e) {
                RoughlyEnoughItemsCore.LOGGER.error("[REI] " + identifier.toString() + " plugin failed to load!", (Throwable)e);
            }
        });
        if (!this.recipeFunctions.isEmpty()) {
            List<Recipe> allSortedRecipes = this.getAllSortedRecipes();
            Collections.reverse(allSortedRecipes);
            this.recipeFunctions.forEach(recipeFunction -> {
                try {
                    allSortedRecipes.stream().filter(recipe -> recipeFunction.recipeFilter.test((Recipe)recipe)).forEach(t -> this.registerDisplay(recipeFunction.category, (RecipeDisplay)recipeFunction.mappingFunction.apply(t), 0));
                }
                catch (Exception e) {
                    RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to add recipes!", (Throwable)e);
                }
            });
        }
        if (this.getDisplayVisibilityHandlers().isEmpty()) {
            this.registerRecipeVisibilityHandler(new DisplayVisibilityHandler(){

                @Override
                public DisplayVisibility handleDisplay(RecipeCategory category, RecipeDisplay display) {
                    return DisplayVisibility.ALWAYS_VISIBLE;
                }

                @Override
                public float getPriority() {
                    return -1.0f;
                }
            });
        }
        this.categoryDisplaySettingsMap.clear();
        this.categories.forEach(category -> this.categoryDisplaySettingsMap.put(category.getIdentifier(), category.getDisplaySettings()));
        ((DisplayHelperImpl)RoughlyEnoughItemsCore.getDisplayHelper()).resetCache();
        ScreenHelper.getOptionalOverlay().ifPresent(overlay -> {
            overlay.shouldReInit = true;
        });
        long usedTime = System.currentTimeMillis() - startTime;
        RoughlyEnoughItemsCore.LOGGER.info("[REI] Registered %d stack entries, %d recipes displays, %d bounds handler, %d visibility handlers and %d categories (%s) in %d ms.", (Object)RoughlyEnoughItemsCore.getItemRegisterer().getItemList().size(), (Object)this.recipeCount.get(), (Object)RoughlyEnoughItemsCore.getDisplayHelper().getAllBoundsHandlers().size(), (Object)this.getDisplayVisibilityHandlers().size(), (Object)this.categories.size(), (Object)String.join((CharSequence)", ", this.categories.stream().map(RecipeCategory::getCategoryName).collect(Collectors.toList())), (Object)usedTime);
    }

    @Override
    public int getRecipeCount() {
        return this.recipeCount.get();
    }

    @Override
    public List<Recipe> getAllSortedRecipes() {
        return this.getRecipeManager().values().stream().sorted(RECIPE_COMPARATOR).collect(Collectors.toList());
    }

    @Override
    public Map<RecipeCategory, List<RecipeDisplay>> getAllRecipes() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        this.categories.forEach(recipeCategory -> {
            List list;
            if (this.recipeCategoryListMap.containsKey(recipeCategory.getIdentifier()) && !(list = this.recipeCategoryListMap.get(recipeCategory.getIdentifier()).stream().filter(display -> this.isDisplayVisible((RecipeDisplay)display)).collect(Collectors.toList())).isEmpty()) {
                map.put(recipeCategory, list);
            }
        });
        return map;
    }

    @Override
    public void registerRecipeVisibilityHandler(DisplayVisibilityHandler visibilityHandler) {
        this.displayVisibilityHandlers.add(visibilityHandler);
    }

    @Override
    public void unregisterRecipeVisibilityHandler(DisplayVisibilityHandler visibilityHandler) {
        this.displayVisibilityHandlers.remove(visibilityHandler);
    }

    @Override
    public List<DisplayVisibilityHandler> getDisplayVisibilityHandlers() {
        return Collections.unmodifiableList(this.displayVisibilityHandlers);
    }

    @Override
    public boolean isDisplayVisible(RecipeDisplay display, boolean respectConfig) {
        return this.isDisplayVisible(display);
    }

    @Override
    public boolean isDisplayVisible(RecipeDisplay display) {
        RecipeCategory category = this.getCategory(display.getRecipeCategory());
        List list = this.getDisplayVisibilityHandlers().stream().sorted(VISIBILITY_HANDLER_COMPARATOR).collect(Collectors.toList());
        for (DisplayVisibilityHandler displayVisibilityHandler : list) {
            try {
                DisplayVisibility visibility = displayVisibilityHandler.handleDisplay(category, display);
                if (visibility == DisplayVisibility.PASS) continue;
                return visibility == DisplayVisibility.ALWAYS_VISIBLE || visibility == DisplayVisibility.CONFIG_OPTIONAL;
            }
            catch (Throwable throwable) {
                RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to check if the recipe is visible!", throwable);
            }
        }
        return true;
    }

    @Override
    public <T extends Recipe<?>> void registerRecipes(Identifier category, Class<T> recipeClass, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipe -> recipeClass.isAssignableFrom(recipe.getClass()), mappingFunction));
    }

    @Override
    public <T extends Recipe<?>> void registerRecipes(Identifier category, Function<Recipe, Boolean> recipeFilter, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipeFilter::apply, mappingFunction));
    }

    @Override
    public <T extends Recipe<?>> void registerRecipes(Identifier category, Predicate<Recipe> recipeFilter, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipeFilter, mappingFunction));
    }

    @Override
    public Optional<DisplaySettings> getCachedCategorySettings(Identifier category) {
        return this.categoryDisplaySettingsMap.entrySet().stream().filter(entry -> ((Identifier)entry.getKey()).equals((Object)category)).map(Map.Entry::getValue).findAny();
    }

    @Override
    public void registerLiveRecipeGenerator(LiveRecipeGenerator liveRecipeGenerator) {
        this.liveRecipeGenerators.add(liveRecipeGenerator);
    }

    static {
        RECIPE_COMPARATOR = (o1, o2) -> {
            int int_1 = o1.getId().getNamespace().compareTo(o2.getId().getNamespace());
            if (int_1 == 0) {
                int_1 = o1.getId().getPath().compareTo(o2.getId().getPath());
            }
            return int_1;
        };
        Comparator<DisplayVisibilityHandler> comparator = Comparator.comparingDouble(DisplayVisibilityHandler::getPriority);
        VISIBILITY_HANDLER_COMPARATOR = comparator.reversed();
    }

    private class RecipeFunction {
        Identifier category;
        Predicate<Recipe> recipeFilter;
        Function mappingFunction;

        public RecipeFunction(Identifier category, Predicate<Recipe> recipeFilter, Function<?, RecipeDisplay> mappingFunction) {
            this.category = category;
            this.recipeFilter = recipeFilter;
            this.mappingFunction = mappingFunction;
        }
    }
}

