/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.client.RecipeScreenType;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.HighlightableWidget;
import me.shedaniel.rei.gui.widget.Widget;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.Element;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.render.GuiLighting;
import net.minecraft.client.resource.language.I18n;
import net.minecraft.client.sound.PositionedSoundInstance;
import net.minecraft.client.sound.SoundInstance;
import net.minecraft.sound.SoundEvent;
import net.minecraft.sound.SoundEvents;
import net.minecraft.text.Text;
import net.minecraft.text.TranslatableText;
import net.minecraft.util.Formatting;
import net.minecraft.util.Identifier;

public class PreRecipeViewingScreen
extends Screen {
    private static final Identifier IDENTIFIER = new Identifier("roughlyenoughitems", "textures/gui/screenshot.png");
    private final List<Widget> widgets = Lists.newArrayList();
    private boolean original = true;
    private Map<RecipeCategory, List<RecipeDisplay>> map;

    public PreRecipeViewingScreen(Map<RecipeCategory, List<RecipeDisplay>> map) {
        super((Text)new TranslatableText("text.rei.recipe_screen_type.selection", new Object[0]));
        this.map = map;
    }

    protected void init() {
        this.children.clear();
        this.widgets.clear();
        this.widgets.add(new ButtonWidget(this.width / 2 - 100, this.height - 40, 200, 20, I18n.translate((String)"text.rei.select", (Object[])new Object[0])){

            @Override
            public void onPressed() {
                RoughlyEnoughItemsCore.getConfigManager().getConfig().screenType = PreRecipeViewingScreen.this.original ? RecipeScreenType.ORIGINAL : RecipeScreenType.VILLAGER;
                try {
                    RoughlyEnoughItemsCore.getConfigManager().saveConfig();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ClientHelper.getInstance().openRecipeViewingScreen(PreRecipeViewingScreen.this.map);
            }
        });
        this.widgets.add(new ScreenTypeSelection(this.width / 2 - 200 - 5, this.height / 2 - 56 - 10, 0));
        this.widgets.add(new ScreenTypeSelection(this.width / 2 + 5, this.height / 2 - 56 - 10, 112));
        this.children.addAll(this.widgets);
    }

    public void render(int int_1, int int_2, float float_1) {
        this.renderBackground();
        this.drawCenteredString(this.font, this.title.asFormattedString(), this.width / 2, 20, 0xFFFFFF);
        int i = 30;
        for (String s : this.font.wrapStringToWidthAsList(I18n.translate((String)"text.rei.recipe_screen_type.selection.sub", (Object[])new Object[0]), this.width - 30)) {
            this.drawCenteredString(this.font, Formatting.GRAY.toString() + s, this.width / 2, i, -1);
            i += 10;
        }
        super.render(int_1, int_2, float_1);
        this.widgets.forEach(widget -> {
            GuiLighting.disable();
            widget.render(int_1, int_2, float_1);
        });
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if ((int_1 == 256 || this.minecraft.options.keyInventory.matchesKey(int_1, int_2)) && this.shouldCloseOnEsc()) {
            MinecraftClient.getInstance().openScreen((Screen)ScreenHelper.getLastContainerScreen());
            ScreenHelper.getLastOverlay().init();
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }

    public class ScreenTypeSelection
    extends HighlightableWidget {
        private Rectangle bounds;
        private int u;
        private int v;

        public ScreenTypeSelection(int x, int y, int v) {
            this.bounds = new Rectangle(x - 4, y - 4, 208, 120);
            this.u = 0;
            this.v = v;
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }

        public void render(int i, int i1, float delta) {
            MinecraftClient.getInstance().getTextureManager().bindTexture(IDENTIFIER);
            this.blit(this.bounds.x + 4, this.bounds.y + 4, this.u, this.v, 200, 112);
            if (PreRecipeViewingScreen.this.original == (this.v == 0)) {
                this.fillGradient(this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y + 2, -1, -1);
                this.fillGradient(this.bounds.x, this.bounds.y + this.bounds.height - 2, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height, -1, -1);
                this.fillGradient(this.bounds.x, this.bounds.y, this.bounds.x + 2, this.bounds.y + this.bounds.height, -1, -1);
                this.fillGradient(this.bounds.x + this.bounds.width - 2, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height, -1, -1);
            }
        }

        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            if (this.isHighlighted(double_1, double_2)) {
                this.minecraft.getSoundManager().play((SoundInstance)PositionedSoundInstance.master((SoundEvent)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                PreRecipeViewingScreen.this.original = this.v == 0;
                return true;
            }
            return false;
        }

        public List<? extends Element> children() {
            return Collections.emptyList();
        }
    }
}

