/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.config;

import me.shedaniel.rei.client.ItemListOrdering;
import net.minecraft.client.resource.language.I18n;

public enum ItemListOrderingConfig {
    REGISTRY_ASCENDING(ItemListOrdering.registry, true),
    NAME_ASCENDING(ItemListOrdering.name, true),
    GROUPS_ASCENDING(ItemListOrdering.item_groups, true),
    REGISTRY_DESCENDING(ItemListOrdering.registry, false),
    NAME_DESCENDING(ItemListOrdering.name, false),
    GROUPS_DESCENDING(ItemListOrdering.item_groups, false);

    private ItemListOrdering ordering;
    private boolean isAscending;

    private ItemListOrderingConfig(ItemListOrdering ordering, boolean isAscending) {
        this.ordering = ordering;
        this.isAscending = isAscending;
    }

    public static ItemListOrderingConfig from(ItemListOrdering ordering, boolean isAscending) {
        int index = ordering.ordinal() + (isAscending ? 0 : 3);
        return ItemListOrderingConfig.values()[index];
    }

    public ItemListOrdering getOrdering() {
        return this.ordering;
    }

    public boolean isAscending() {
        return this.isAscending;
    }

    public String toString() {
        return I18n.translate((String)"text.rei.config.list_ordering_button", (Object[])new Object[]{I18n.translate((String)this.getOrdering().getNameTranslationKey(), (Object[])new Object[0]), I18n.translate((String)(this.isAscending ? "ordering.rei.ascending" : "ordering.rei.descending"), (Object[])new Object[0])});
    }
}

