/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.renderables;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.widget.ItemListOverlay;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.render.GuiLighting;
import net.minecraft.client.render.item.ItemRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Identifier;

public abstract class ItemStackRenderer
extends Renderer {
    public static final Identifier CHEST_GUI_TEXTURE = new Identifier("roughlyenoughitems", "textures/gui/recipecontainer.png");
    public boolean drawTooltip = false;

    @Override
    public void render(int x, int y, double mouseX, double mouseY, float delta) {
        int l = x - 8;
        int i1 = y - 6;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemRenderer itemRenderer = MinecraftClient.getInstance().getItemRenderer();
        itemRenderer.zOffset = this.blitOffset;
        GuiLighting.enableForItems();
        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.enableLighting();
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableDepthTest();
        itemRenderer.renderGuiItem(this.getItemStack(), l, i1);
        itemRenderer.renderGuiItemOverlay(MinecraftClient.getInstance().textRenderer, this.getItemStack(), l, i1);
        itemRenderer.zOffset = 0.0f;
        this.blitOffset = 0;
        if (this.drawTooltip && mouseX >= (double)(x - 8) && mouseX <= (double)(x + 8) && mouseY >= (double)(y - 6) && mouseY <= (double)(y + 10)) {
            this.queueTooltip(this.getItemStack(), delta);
        }
        this.drawTooltip = false;
    }

    protected void queueTooltip(ItemStack itemStack, float delta) {
        ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(this.getTooltip(itemStack)));
    }

    protected List<String> getTooltip(ItemStack itemStack) {
        String modString = ClientHelper.getInstance().getFormattedModFromItem(itemStack.getItem());
        ArrayList toolTip = Lists.newArrayList(ItemListOverlay.tryGetItemStackToolTip(itemStack, true));
        toolTip.addAll(this.getExtraToolTips(itemStack));
        boolean alreadyHasMod = false;
        for (String s : toolTip) {
            if (!s.equalsIgnoreCase(modString)) continue;
            alreadyHasMod = true;
            break;
        }
        if (!alreadyHasMod) {
            toolTip.add(modString);
        }
        return toolTip;
    }

    protected List<String> getExtraToolTips(ItemStack stack) {
        return Collections.emptyList();
    }

    public abstract ItemStack getItemStack();
}

