/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.renderables;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.Renderable;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import me.shedaniel.rei.gui.renderables.ItemStackRenderer;
import me.shedaniel.rei.gui.renderables.RecipeRenderer;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.render.GuiLighting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Identifier;
import net.minecraft.util.Pair;
import net.minecraft.util.math.MathHelper;

public class SimpleRecipeRenderer
extends RecipeRenderer {
    public static final Comparator<ItemStack> ITEM_STACK_COMPARATOR = (o1, o2) -> {
        if (o1.getItem() == o2.getItem()) {
            if (o1.getCount() != o2.getCount()) {
                return o1.getCount() - o2.getCount();
            }
            int compare = Boolean.compare(o1.hasTag(), o2.hasTag());
            if (compare != 0) {
                return compare;
            }
            if (o1.getTag().getSize() != o2.getTag().getSize()) {
                return o1.getTag().getSize() - o2.getTag().getSize();
            }
            return o1.getTag().hashCode() - o2.getTag().hashCode();
        }
        return o1.getItem().hashCode() - o2.getItem().hashCode();
    };
    private static final Identifier CHEST_GUI_TEXTURE = new Identifier("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private List<ItemStackRenderer> inputRenderer;
    private ItemStackRenderer outputRenderer;

    public SimpleRecipeRenderer(Supplier<List<List<ItemStack>>> input, Supplier<List<ItemStack>> output) {
        ArrayList newList = Lists.newArrayList();
        List a = input.get().stream().map(stacks -> new Pair(stacks, (Object)stacks.stream().map(ItemStack::getCount).max(Integer::compareTo).orElse(1))).collect(Collectors.toList());
        for (Pair pair : a) {
            Optional<Pair> any = newList.stream().filter(pairr -> SimpleRecipeRenderer.equalsList((List)pair.getLeft(), (List)pairr.getLeft())).findAny();
            if (any.isPresent()) {
                ((AtomicInteger)any.get().getRight()).addAndGet((Integer)pair.getRight());
                continue;
            }
            newList.add(new Pair(pair.getLeft(), (Object)new AtomicInteger((Integer)pair.getRight())));
        }
        ArrayList b = Lists.newArrayList();
        for (Pair pair : newList) {
            b.add(((List)pair.getLeft()).stream().map(stack -> {
                ItemStack s = stack.copy();
                s.setCount(((AtomicInteger)pair.getRight()).get());
                return s;
            }).collect(Collectors.toList()));
        }
        this.inputRenderer = b.stream().filter(stacks -> !stacks.isEmpty()).map(stacks -> Renderable.fromItemStacks(stacks)).collect(Collectors.toList());
        this.outputRenderer = Renderable.fromItemStacks(output.get().stream().filter(stack -> !stack.isEmpty()).collect(Collectors.toList()));
    }

    public static boolean equalsList(List<ItemStack> list_1, List<ItemStack> list_2) {
        List stacks_2;
        List stacks_1 = list_1.stream().distinct().sorted(ITEM_STACK_COMPARATOR).collect(Collectors.toList());
        if (stacks_1.equals(stacks_2 = list_2.stream().distinct().sorted(ITEM_STACK_COMPARATOR).collect(Collectors.toList()))) {
            return true;
        }
        if (stacks_1.size() != stacks_2.size()) {
            return false;
        }
        for (int i = 0; i < stacks_1.size(); ++i) {
            if (((ItemStack)stacks_1.get(i)).isItemEqualIgnoreDamage((ItemStack)stacks_2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void render(int x, int y, double mouseX, double mouseY, float delta) {
        int xx = x + 4;
        int yy = y + 2;
        int j = 0;
        int itemsPerLine = this.getItemsPerLine();
        for (ItemStackRenderer itemStackRenderer : this.inputRenderer) {
            itemStackRenderer.setBlitOffset(this.getBlitOffset() + 50);
            itemStackRenderer.drawTooltip = MinecraftClient.getInstance().currentScreen instanceof VillagerRecipeViewingScreen;
            itemStackRenderer.render(xx + 8, yy + 6, mouseX, mouseY, delta);
            xx += 18;
            if (++j < this.getItemsPerLine() - 2) continue;
            yy += 18;
            xx = x + 5;
            j = 0;
        }
        xx = x + 5 + 18 * (this.getItemsPerLine() - 2);
        yy = y + this.getHeight() / 2 - 8;
        GuiLighting.disable();
        MinecraftClient.getInstance().getTextureManager().bindTexture(CHEST_GUI_TEXTURE);
        this.blit(xx, yy, 0, 28, 18, 18);
        this.outputRenderer.setBlitOffset(this.getBlitOffset() + 50);
        this.outputRenderer.drawTooltip = MinecraftClient.getInstance().currentScreen instanceof VillagerRecipeViewingScreen;
        this.outputRenderer.render((xx += 18) + 8, yy + 6, mouseX, mouseY, delta);
    }

    @Override
    public int getHeight() {
        return 4 + this.getItemsHeight() * 18;
    }

    public int getItemsHeight() {
        return MathHelper.ceil((float)((float)this.inputRenderer.size() / (float)(this.getItemsPerLine() - 2)));
    }

    public int getItemsPerLine() {
        return MathHelper.floor((float)(((float)this.getWidth() - 4.0f) / 18.0f));
    }
}

