/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Rectangle;
import java.util.Optional;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import net.minecraft.block.Blocks;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.render.GuiLighting;
import net.minecraft.client.render.item.ItemRenderer;
import net.minecraft.client.resource.language.I18n;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Identifier;

public abstract class CraftableToggleButtonWidget
extends ButtonWidget {
    public static final Identifier CHEST_GUI_TEXTURE = new Identifier("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private ItemRenderer itemRenderer;

    public CraftableToggleButtonWidget(Rectangle rectangle) {
        super(rectangle, "");
        this.itemRenderer = this.minecraft.getItemRenderer();
    }

    public CraftableToggleButtonWidget(int x, int y, int width, int height) {
        this(new Rectangle(x, y, width, height));
    }

    public void lateRender(int mouseX, int mouseY, float delta) {
        GuiLighting.disable();
        super.render(mouseX, mouseY, delta);
        GuiLighting.enableForItems();
        this.itemRenderer.zOffset = this.blitOffset;
        this.itemRenderer.renderGuiItem(new ItemStack((ItemConvertible)Blocks.CRAFTING_TABLE), this.getBounds().x + 2, this.getBounds().y + 2);
        this.itemRenderer.zOffset = 0.0f;
        GuiLighting.disable();
        MinecraftClient.getInstance().getTextureManager().bindTexture(CHEST_GUI_TEXTURE);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int color = RoughlyEnoughItemsCore.getConfigManager().isCraftableOnlyEnabled() ? 939579655 : 956235776;
        this.blitOffset = (int)((float)this.blitOffset + 10.0f);
        this.fillGradient(this.getBounds().x, this.getBounds().y, this.getBounds().x + this.getBounds().width, this.getBounds().y + this.getBounds().height, color, color);
        this.blitOffset = 0;
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
    }

    @Override
    public boolean changeFocus(boolean boolean_1) {
        return false;
    }

    @Override
    public Optional<String> getTooltips() {
        return Optional.ofNullable(I18n.translate((String)(RoughlyEnoughItemsCore.getConfigManager().isCraftableOnlyEnabled() ? "text.rei.showing_craftable" : "text.rei.showing_all"), (Object[])new Object[0]));
    }
}

