/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import me.shedaniel.cloth.api.ClientUtils;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.ItemCheatingMode;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.client.ItemListOrdering;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.client.SearchArgument;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.SlotWidget;
import me.shedaniel.rei.gui.widget.Widget;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.item.TooltipContext;
import net.minecraft.client.network.ClientPlayerEntity;
import net.minecraft.client.render.GuiLighting;
import net.minecraft.client.resource.language.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.text.Text;
import net.minecraft.util.ActionResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import org.apache.commons.lang3.StringUtils;

public class ItemListOverlay
extends Widget {
    private static final String SPACE = " ";
    private static final String EMPTY = "";
    private static final Comparator<ItemStack> ASCENDING_COMPARATOR;
    private static List<Item> searchBlacklisted;
    private final List<SearchArgument[]> lastSearchArgument;
    private List<ItemStack> currentDisplayed = Lists.newArrayList();
    private List<Widget> widgets;
    private int width = 0;
    private int height = 0;
    private int page;
    private Rectangle rectangle;
    private Rectangle listArea;

    public ItemListOverlay(int page) {
        this.page = page;
        this.lastSearchArgument = Lists.newArrayList();
    }

    public static List<String> tryGetItemStackToolTip(ItemStack itemStack, boolean careAboutAdvanced) {
        if (!searchBlacklisted.contains(itemStack.getItem())) {
            try {
                return itemStack.getTooltip((PlayerEntity)MinecraftClient.getInstance().player, (TooltipContext)(MinecraftClient.getInstance().options.advancedItemTooltips && careAboutAdvanced ? TooltipContext.Default.ADVANCED : TooltipContext.Default.NORMAL)).stream().map(Text::asFormattedString).collect(Collectors.toList());
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(itemStack.getItem());
            }
        }
        return Collections.singletonList(ItemListOverlay.tryGetItemStackName(itemStack));
    }

    public static String tryGetItemStackName(ItemStack stack) {
        if (!searchBlacklisted.contains(stack.getItem())) {
            try {
                return stack.getName().asFormattedString();
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(stack.getItem());
            }
        }
        try {
            return I18n.translate((String)("item." + Registry.ITEM.getId((Object)stack.getItem()).toString().replace(":", ".")), (Object[])new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public static boolean filterItem(ItemStack itemStack, List<SearchArgument[]> arguments) {
        if (arguments.isEmpty()) {
            return true;
        }
        AtomicReference<String> mod = null;
        AtomicReference<String> tooltips = null;
        AtomicReference<String> name = null;
        for (SearchArgument[] arguments1 : arguments) {
            boolean b = true;
            for (SearchArgument argument : arguments1) {
                if (argument.getArgumentType().equals((Object)SearchArgument.ArgumentType.ALWAYS)) {
                    return true;
                }
                if (argument.getArgumentType().equals((Object)SearchArgument.ArgumentType.MOD) && argument.getFunction(!argument.isInclude()).apply(ItemListOverlay.fillMod(itemStack, mod)).booleanValue()) {
                    b = false;
                    break;
                }
                if (argument.getArgumentType().equals((Object)SearchArgument.ArgumentType.TOOLTIP) && argument.getFunction(!argument.isInclude()).apply(ItemListOverlay.fillTooltip(itemStack, tooltips)).booleanValue()) {
                    b = false;
                    break;
                }
                if (!argument.getArgumentType().equals((Object)SearchArgument.ArgumentType.TEXT) || !argument.getFunction(!argument.isInclude()).apply(ItemListOverlay.fillName(itemStack, name)).booleanValue()) continue;
                b = false;
                break;
            }
            if (!b) continue;
            return true;
        }
        return false;
    }

    private static String fillMod(ItemStack itemStack, AtomicReference<String> mod) {
        if (mod == null) {
            mod = new AtomicReference<String>(ClientHelper.getInstance().getModFromItem(itemStack.getItem()).toLowerCase(Locale.ROOT));
        }
        return mod.get();
    }

    private static String fillTooltip(ItemStack itemStack, AtomicReference<String> mod) {
        if (mod == null) {
            mod = new AtomicReference<String>(ItemListOverlay.tryGetItemStackToolTip(itemStack, false).stream().collect(Collectors.joining(EMPTY)).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
        }
        return mod.get();
    }

    private static String fillName(ItemStack itemStack, AtomicReference<String> mod) {
        if (mod == null) {
            mod = new AtomicReference<String>(ItemListOverlay.tryGetItemStackName(itemStack).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
        }
        return mod.get();
    }

    public int getFullTotalSlotsPerPage() {
        return this.width * this.height;
    }

    public void render(int int_1, int int_2, float float_1) {
        GuiLighting.disable();
        this.widgets.forEach(widget -> widget.render(int_1, int_2, float_1));
        ClientPlayerEntity player = this.minecraft.player;
        if (this.rectangle.contains(ClientUtils.getMouseLocation()) && ClientHelper.getInstance().isCheating() && !player.inventory.getCursorStack().isEmpty() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
            ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(I18n.translate((String)"text.rei.delete_items", (Object[])new Object[0])));
        }
    }

    public void updateList(DisplayHelper.DisplayBoundsHandler boundsHandler, Rectangle rectangle, int page, String searchTerm, boolean processSearchTerm) {
        this.rectangle = rectangle;
        this.page = page;
        this.widgets = Lists.newLinkedList();
        this.calculateListSize(rectangle);
        if (this.currentDisplayed.isEmpty() || processSearchTerm) {
            this.currentDisplayed = this.processSearchTerm(searchTerm, RoughlyEnoughItemsCore.getItemRegisterer().getItemList(), new ArrayList<ItemStack>(ScreenHelper.inventoryStacks));
        }
        int startX = (int)rectangle.getCenterX() - this.width * 9;
        int startY = (int)rectangle.getCenterY() - this.height * 9;
        this.listArea = new Rectangle(startX, startY, this.width * 18, this.height * 18);
        int fitSlotsPerPage = this.getTotalFitSlotsPerPage(startX, startY, this.listArea);
        int j = page * fitSlotsPerPage;
        for (int yy = 0; yy < this.height; ++yy) {
            for (int xx = 0; xx < this.width; ++xx) {
                int x = startX + xx * 18;
                int y = startY + yy * 18;
                if (!this.canBeFit(x, y, this.listArea)) continue;
                if (++j > this.currentDisplayed.size()) break;
                this.widgets.add(new SlotWidget(x, y, Collections.singletonList(this.currentDisplayed.get(j - 1)), false, true, true){

                    @Override
                    protected void queueTooltip(ItemStack itemStack, float delta) {
                        ClientPlayerEntity player = this.minecraft.player;
                        if (!ClientHelper.getInstance().isCheating() || player.inventory.getCursorStack().isEmpty()) {
                            super.queueTooltip(itemStack, delta);
                        }
                    }

                    @Override
                    public boolean mouseClicked(double mouseX, double mouseY, int button) {
                        if (this.isCurrentRendererItem() && this.isHighlighted(mouseX, mouseY)) {
                            if (ClientHelper.getInstance().isCheating()) {
                                if (this.getCurrentItemStack() != null && !this.getCurrentItemStack().isEmpty()) {
                                    ItemStack cheatedStack = this.getCurrentItemStack().copy();
                                    if (RoughlyEnoughItemsCore.getConfigManager().getConfig().itemCheatingMode == ItemCheatingMode.REI_LIKE) {
                                        cheatedStack.setCount(button != 1 ? 1 : cheatedStack.getMaxCount());
                                    } else if (RoughlyEnoughItemsCore.getConfigManager().getConfig().itemCheatingMode == ItemCheatingMode.JEI_LIKE) {
                                        cheatedStack.setCount(button != 0 ? 1 : cheatedStack.getMaxCount());
                                    } else {
                                        cheatedStack.setCount(1);
                                    }
                                    return ClientHelper.getInstance().tryCheatingStack(cheatedStack);
                                }
                            } else {
                                if (button == 0) {
                                    return ClientHelper.getInstance().executeRecipeKeyBind(this.getCurrentItemStack().copy());
                                }
                                if (button == 1) {
                                    return ClientHelper.getInstance().executeUsageKeyBind(this.getCurrentItemStack().copy());
                                }
                            }
                        }
                        return false;
                    }
                });
            }
            if (j > this.currentDisplayed.size()) break;
        }
    }

    public int getTotalPage() {
        int fitSlotsPerPage = this.getTotalFitSlotsPerPage(this.listArea.x, this.listArea.y, this.listArea);
        if (fitSlotsPerPage > 0) {
            return MathHelper.ceil((float)(this.getCurrentDisplayed().size() / fitSlotsPerPage));
        }
        return 0;
    }

    public int getTotalFitSlotsPerPage(int startX, int startY, Rectangle listArea) {
        int slots = 0;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!this.canBeFit(startX + x * 18, startY + y * 18, listArea)) continue;
                ++slots;
            }
        }
        return slots;
    }

    public boolean canBeFit(int left, int top, Rectangle listArea) {
        for (DisplayHelper.DisplayBoundsHandler sortedBoundsHandler : RoughlyEnoughItemsCore.getDisplayHelper().getSortedBoundsHandlers(this.minecraft.currentScreen.getClass())) {
            ActionResult fit = sortedBoundsHandler.canItemSlotWidgetFit(!RoughlyEnoughItemsCore.getConfigManager().getConfig().mirrorItemPanel, left, top, this.minecraft.currentScreen, listArea);
            if (fit == ActionResult.PASS) continue;
            return fit == ActionResult.SUCCESS;
        }
        return true;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        for (Widget widget : this.widgets) {
            if (!widget.keyPressed(int_1, int_2, int_3)) continue;
            return true;
        }
        return false;
    }

    public Rectangle getListArea() {
        return this.listArea;
    }

    public List<ItemStack> getCurrentDisplayed() {
        return this.currentDisplayed;
    }

    private List<ItemStack> processSearchTerm(String searchTerm, List<ItemStack> ol, List<ItemStack> inventoryItems) {
        this.lastSearchArgument.clear();
        List<Object> os = new LinkedList<ItemStack>(ol);
        if (RoughlyEnoughItemsCore.getConfigManager().getConfig().itemListOrdering != ItemListOrdering.registry) {
            os = ol.stream().sorted(ASCENDING_COMPARATOR).collect(Collectors.toList());
        }
        if (!RoughlyEnoughItemsCore.getConfigManager().getConfig().isAscending) {
            Collections.reverse(os);
        }
        String[] splitSearchTerm = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)searchTerm, (String)"|");
        Arrays.stream(splitSearchTerm).forEachOrdered(s -> {
            String[] split = StringUtils.split((String)s);
            SearchArgument[] arguments = new SearchArgument[split.length];
            for (int i = 0; i < split.length; ++i) {
                String s1 = split[i];
                arguments[i] = s1.startsWith("@-") || s1.startsWith("-@") ? new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(2), false) : (s1.startsWith("@") ? new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(1), true) : (s1.startsWith("#-") || s1.startsWith("-#") ? new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(2), false) : (s1.startsWith("#") ? new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(1), true) : (s1.startsWith("-") ? new SearchArgument(SearchArgument.ArgumentType.TEXT, s1.substring(1), false) : new SearchArgument(SearchArgument.ArgumentType.TEXT, s1, true)))));
            }
            if (arguments.length > 0) {
                this.lastSearchArgument.add(arguments);
            } else {
                this.lastSearchArgument.add(new SearchArgument[]{SearchArgument.ALWAYS});
            }
        });
        List<Object> stacks = Collections.emptyList();
        stacks = this.lastSearchArgument.isEmpty() ? Collections.unmodifiableList(os) : Collections.unmodifiableList(os.stream().filter(itemStack -> ItemListOverlay.filterItem(itemStack, this.lastSearchArgument)).collect(Collectors.toList()));
        if (!RoughlyEnoughItemsCore.getConfigManager().isCraftableOnlyEnabled() || stacks.isEmpty() || inventoryItems.isEmpty()) {
            return stacks;
        }
        ArrayList workingItems = Lists.newArrayList(RecipeHelper.getInstance().findCraftableByItems(inventoryItems));
        return stacks.stream().filter(itemStack -> workingItems.stream().anyMatch(stack -> stack.isItemEqualIgnoreDamage(itemStack))).collect(Collectors.toList());
    }

    public List<SearchArgument[]> getLastSearchArgument() {
        return this.lastSearchArgument;
    }

    public void calculateListSize(Rectangle rect) {
        int xOffset = 0;
        int yOffset = 0;
        this.width = 0;
        this.height = 0;
        do {
            xOffset += 18;
            if (this.height == 0) {
                ++this.width;
            }
            if (xOffset + 19 <= rect.width) continue;
            xOffset = 0;
            yOffset += 18;
            ++this.height;
        } while (yOffset + 19 <= rect.height);
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (this.rectangle.contains(double_1, double_2)) {
            ClientPlayerEntity player = this.minecraft.player;
            if (ClientHelper.getInstance().isCheating() && !player.inventory.getCursorStack().isEmpty() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            if (!player.inventory.getCursorStack().isEmpty() && RoughlyEnoughItemsCore.hasPermissionToUsePackets()) {
                return false;
            }
            for (Widget widget : this.children()) {
                if (!widget.mouseClicked(double_1, double_2, int_1)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Widget> children() {
        return this.widgets;
    }

    static {
        searchBlacklisted = Lists.newArrayList();
        ASCENDING_COMPARATOR = (itemStack, t1) -> {
            if (RoughlyEnoughItemsCore.getConfigManager().getConfig().itemListOrdering.equals((Object)ItemListOrdering.name)) {
                return ItemListOverlay.tryGetItemStackName(itemStack).compareToIgnoreCase(ItemListOverlay.tryGetItemStackName(t1));
            }
            if (RoughlyEnoughItemsCore.getConfigManager().getConfig().itemListOrdering.equals((Object)ItemListOrdering.item_groups)) {
                List<ItemGroup> itemGroups = Arrays.asList(ItemGroup.GROUPS);
                return itemGroups.indexOf(itemStack.getItem().getGroup()) - itemGroups.indexOf(t1.getItem().getGroup());
            }
            return 0;
        };
    }
}

