/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import me.shedaniel.cloth.api.ClientUtils;

public class QueuedTooltip {
    private Point location;
    private List<String> text;
    private Consumer<QueuedTooltip> consumer = null;

    private QueuedTooltip(Point location, List<String> text) {
        this.location = location;
        this.text = Collections.unmodifiableList(text);
    }

    public static QueuedTooltip create(Point location, List<String> text) {
        return new QueuedTooltip(location, text);
    }

    public static QueuedTooltip create(Point location, String ... text) {
        return QueuedTooltip.create(location, Lists.newArrayList((Object[])text));
    }

    public static QueuedTooltip create(List<String> text) {
        return QueuedTooltip.create(ClientUtils.getMouseLocation(), text);
    }

    public static QueuedTooltip create(String ... text) {
        return QueuedTooltip.create(ClientUtils.getMouseLocation(), text);
    }

    @Deprecated
    public QueuedTooltip setSpecialRenderer(Consumer<QueuedTooltip> consumer) {
        this.consumer = consumer;
        return this;
    }

    @Deprecated
    public Consumer<QueuedTooltip> getConsumer() {
        return this.consumer;
    }

    public Point getLocation() {
        return this.location;
    }

    public int getX() {
        return this.getLocation().x;
    }

    public int getY() {
        return this.getLocation().y;
    }

    public List<String> getText() {
        return this.text;
    }
}

