/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.client.RecipeScreenType;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.widget.HighlightableWidget;
import me.shedaniel.rei.gui.widget.Widget;
import net.minecraft.client.render.GuiLighting;
import net.minecraft.util.Identifier;

public class RecipeBaseWidget
extends HighlightableWidget {
    private static final Identifier CHEST_GUI_TEXTURE = new Identifier("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private static final Identifier CHEST_GUI_TEXTURE_DARK = new Identifier("roughlyenoughitems", "textures/gui/recipecontainer_dark.png");
    private Rectangle bounds;

    public RecipeBaseWidget(Rectangle bounds) {
        this.bounds = bounds;
        if (bounds.width < 8 || bounds.height < 8) {
            throw new IllegalArgumentException("Base too small, at least 8x8!");
        }
    }

    public int getBlitOffset() {
        return this.blitOffset;
    }

    public void setBlitOffset(int offset) {
        this.blitOffset = offset;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public List<Widget> children() {
        return Collections.emptyList();
    }

    public void render() {
        this.render(0, 0, 0.0f);
    }

    public void render(int mouseX, int mouseY, float delta) {
        if (!this.isRendering()) {
            return;
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiLighting.disable();
        this.minecraft.getTextureManager().bindTexture(ScreenHelper.isDarkModeEnabled() ? CHEST_GUI_TEXTURE_DARK : CHEST_GUI_TEXTURE);
        int x = this.bounds.x;
        int y = this.bounds.y;
        int width = this.bounds.width;
        int height = this.bounds.height;
        int textureOffset = this.getTextureOffset();
        this.blit(x, y, 106, 124 + textureOffset, 4, 4);
        this.blit(x + width - 4, y, 252, 124 + textureOffset, 4, 4);
        this.blit(x, y + height - 4, 106, 186 + textureOffset, 4, 4);
        this.blit(x + width - 4, y + height - 4, 252, 186 + textureOffset, 4, 4);
        for (int xx = 4; xx < width - 4; xx += 128) {
            int thisWidth = Math.min(128, width - 4 - xx);
            this.blit(x + xx, y, 110, 124 + textureOffset, thisWidth, 4);
            this.blit(x + xx, y + height - 4, 110, 186 + textureOffset, thisWidth, 4);
        }
        for (int yy = 4; yy < height - 4; yy += 50) {
            int thisHeight = Math.min(50, height - 4 - yy);
            this.blit(x, y + yy, 106, 128 + textureOffset, 4, thisHeight);
            this.blit(x + width - 4, y + yy, 252, 128 + textureOffset, 4, thisHeight);
        }
        this.fillGradient(x + 4, y + 4, x + width - 4, y + height - 4, this.getInnerColor(), this.getInnerColor());
    }

    protected boolean isRendering() {
        return RoughlyEnoughItemsCore.getConfigManager().getConfig().screenType != RecipeScreenType.VILLAGER;
    }

    protected int getInnerColor() {
        return ScreenHelper.isDarkModeEnabled() ? -13750738 : -3750202;
    }

    protected int getTextureOffset() {
        return RoughlyEnoughItemsCore.getConfigManager().getConfig().lightGrayRecipeBorder ? 0 : 66;
    }
}

