/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import java.awt.Rectangle;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.SpeedCraftFunctional;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resource.language.I18n;
import net.minecraft.recipe.Recipe;
import net.minecraft.util.Formatting;

public class SpeedCraftingButtonWidget
extends ButtonWidget {
    private final Supplier<RecipeDisplay> displaySupplier;
    private final SpeedCraftFunctional functional;
    private String extraTooltip;

    public SpeedCraftingButtonWidget(Rectangle rectangle, String text, SpeedCraftFunctional functional, Supplier<RecipeDisplay> displaySupplier) {
        super(rectangle, text);
        this.displaySupplier = displaySupplier;
        this.functional = functional;
        Optional<Recipe> recipe = displaySupplier.get().getRecipe();
        this.extraTooltip = recipe.isPresent() ? I18n.translate((String)"text.rei.recipe_id", (Object[])new Object[]{Formatting.GRAY.toString(), recipe.get().getId().toString()}) : "";
    }

    @Override
    public void onPressed() {
        this.minecraft.openScreen((Screen)ScreenHelper.getLastContainerScreen());
        ScreenHelper.getLastOverlay().init();
        this.functional.performAutoCraft((Screen)ScreenHelper.getLastContainerScreen(), this.displaySupplier.get());
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        this.enabled = this.functional != null && this.functional.acceptRecipe((Screen)ScreenHelper.getLastContainerScreen(), this.displaySupplier.get());
        super.render(mouseX, mouseY, delta);
    }

    @Override
    public Optional<String> getTooltips() {
        if (this.minecraft.options.advancedItemTooltips) {
            if (this.enabled) {
                return Optional.ofNullable(I18n.translate((String)"text.speed_craft.move_items", (Object[])new Object[0]) + this.extraTooltip);
            }
            return Optional.ofNullable(I18n.translate((String)"text.speed_craft.failed_move_items", (Object[])new Object[0]) + this.extraTooltip);
        }
        if (this.enabled) {
            return Optional.ofNullable(I18n.translate((String)"text.speed_craft.move_items", (Object[])new Object[0]));
        }
        return Optional.ofNullable(I18n.translate((String)"text.speed_craft.failed_move_items", (Object[])new Object[0]));
    }
}

