/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.mixin;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import me.shedaniel.rei.plugin.BrewingRecipe;
import me.shedaniel.rei.plugin.DefaultBrewingDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PotionItem;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtil;
import net.minecraft.recipe.BrewingRecipeRegistry;
import net.minecraft.recipe.Ingredient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BrewingRecipeRegistry.class})
public class MixinBrewingRecipeRegistry {
    private static final List<BrewingRecipe> SELF_ITEM_RECIPES = Lists.newArrayList();
    private static final List<Potion> REGISTERED_POTION_TYPES = Lists.newArrayList();
    private static final List<Ingredient> SELF_POTION_TYPES = Lists.newArrayList();

    @Inject(method={"registerPotionType"}, at={@At(value="RETURN")})
    private static void method_8080(Item item_1, CallbackInfo ci) {
        if (item_1 instanceof PotionItem) {
            SELF_POTION_TYPES.add(Ingredient.ofItems((ItemConvertible[])new ItemConvertible[]{item_1}));
        }
    }

    @Inject(method={"registerItemRecipe"}, at={@At(value="RETURN")})
    private static void method_8071(Item item_1, Item item_2, Item item_3, CallbackInfo ci) {
        if (item_1 instanceof PotionItem && item_3 instanceof PotionItem) {
            SELF_ITEM_RECIPES.add(new BrewingRecipe(item_1, Ingredient.ofItems((ItemConvertible[])new ItemConvertible[]{item_2}), item_3));
        }
    }

    @Inject(method={"registerPotionRecipe"}, at={@At(value="RETURN")})
    private static void registerPotionRecipe(Potion potion_1, Item item_1, Potion potion_2, CallbackInfo ci) {
        if (!REGISTERED_POTION_TYPES.contains(potion_1)) {
            MixinBrewingRecipeRegistry.rei_registerPotionType(potion_1);
        }
        if (!REGISTERED_POTION_TYPES.contains(potion_2)) {
            MixinBrewingRecipeRegistry.rei_registerPotionType(potion_2);
        }
        SELF_POTION_TYPES.stream().map(Ingredient::getStackArray).forEach(itemStacks -> Arrays.stream(itemStacks).forEach(stack -> DefaultPlugin.registerBrewingDisplay(new DefaultBrewingDisplay(PotionUtil.setPotion((ItemStack)stack.copy(), (Potion)potion_1), Ingredient.ofItems((ItemConvertible[])new ItemConvertible[]{item_1}), PotionUtil.setPotion((ItemStack)stack.copy(), (Potion)potion_2)))));
    }

    private static void rei_registerPotionType(Potion potion) {
        REGISTERED_POTION_TYPES.add(potion);
        SELF_ITEM_RECIPES.forEach(recipe -> DefaultPlugin.registerBrewingDisplay(new DefaultBrewingDisplay(PotionUtil.setPotion((ItemStack)recipe.input.getStackForRender(), (Potion)potion), recipe.ingredient, PotionUtil.setPotion((ItemStack)recipe.output.getStackForRender(), (Potion)potion))));
    }
}

