/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.Renderable;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.renderables.RecipeRenderer;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import me.shedaniel.rei.gui.widget.SlotWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.plugin.DefaultBlastingDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.block.Blocks;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.render.GuiLighting;
import net.minecraft.client.resource.language.I18n;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Formatting;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.MathHelper;

public class DefaultBlastingCategory
implements RecipeCategory<DefaultBlastingDisplay> {
    @Override
    public Identifier getIdentifier() {
        return DefaultPlugin.BLASTING;
    }

    @Override
    public Renderer getIcon() {
        return Renderable.fromItemStack(new ItemStack((ItemConvertible)Blocks.BLAST_FURNACE));
    }

    @Override
    public String getCategoryName() {
        return I18n.translate((String)"category.rei.blasting", (Object[])new Object[0]);
    }

    @Override
    public RecipeRenderer getSimpleRenderer(DefaultBlastingDisplay recipe) {
        return Renderable.fromRecipe(() -> Arrays.asList(recipe.getInput().get(0)), recipe::getOutput);
    }

    @Override
    public List<Widget> setupDisplay(Supplier<DefaultBlastingDisplay> recipeDisplaySupplier, Rectangle bounds) {
        DefaultBlastingDisplay recipeDisplay = recipeDisplaySupplier.get();
        final Point startPoint = new Point((int)bounds.getCenterX() - 41, (int)bounds.getCenterY() - 27);
        LinkedList<Widget> widgets = new LinkedList<Widget>(Arrays.asList(new 1[]{new RecipeBaseWidget(bounds){

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                super.render(mouseX, mouseY, delta);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiLighting.disable();
                MinecraftClient.getInstance().getTextureManager().bindTexture(DefaultPlugin.getDisplayTexture());
                this.blit(startPoint.x, startPoint.y, 0, 54, 82, 54);
                int height = MathHelper.ceil((double)((double)(System.currentTimeMillis() / 250L) % 14.0 / 1.0));
                this.blit(startPoint.x + 2, startPoint.y + 21 + (14 - height), 82, 77 + (14 - height), 14, height);
                int width = MathHelper.ceil((double)((double)(System.currentTimeMillis() / 250L) % 24.0 / 1.0));
                this.blit(startPoint.x + 24, startPoint.y + 18, 82, 91, width, 17);
            }
        }}));
        List<List<ItemStack>> input = recipeDisplay.getInput();
        widgets.add((Object)new SlotWidget(startPoint.x + 1, startPoint.y + 1, input.get(0), true, true, true));
        widgets.add((Object)new SlotWidget(startPoint.x + 1, startPoint.y + 37, recipeDisplay.getFuel(), true, true, true){

            @Override
            protected List<String> getExtraToolTips(ItemStack stack) {
                return Collections.singletonList(Formatting.YELLOW.toString() + I18n.translate((String)"category.rei.smelting.fuel", (Object[])new Object[0]));
            }
        });
        widgets.add((Object)new SlotWidget(startPoint.x + 61, startPoint.y + 19, recipeDisplay.getOutput(), false, true, true));
        return widgets;
    }
}

