/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.Renderable;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import me.shedaniel.rei.gui.widget.SlotWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.plugin.DefaultBrewingDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.block.Blocks;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.render.GuiLighting;
import net.minecraft.client.resource.language.I18n;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Formatting;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.MathHelper;

public class DefaultBrewingCategory
implements RecipeCategory<DefaultBrewingDisplay> {
    @Override
    public Identifier getIdentifier() {
        return DefaultPlugin.BREWING;
    }

    @Override
    public Renderer getIcon() {
        return Renderable.fromItemStack(new ItemStack((ItemConvertible)Blocks.BREWING_STAND));
    }

    @Override
    public String getCategoryName() {
        return I18n.translate((String)"category.rei.brewing", (Object[])new Object[0]);
    }

    @Override
    public List<Widget> setupDisplay(Supplier<DefaultBrewingDisplay> recipeDisplaySupplier, Rectangle bounds) {
        DefaultBrewingDisplay recipeDisplay = recipeDisplaySupplier.get();
        final Point startPoint = new Point((int)bounds.getCenterX() - 52, (int)bounds.getCenterY() - 29);
        LinkedList<Widget> widgets = new LinkedList<Widget>(Arrays.asList(new 1[]{new RecipeBaseWidget(bounds){

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                super.render(mouseX, mouseY, delta);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiLighting.disable();
                MinecraftClient.getInstance().getTextureManager().bindTexture(DefaultPlugin.getDisplayTexture());
                this.blit(startPoint.x, startPoint.y, 0, 108, 103, 59);
                int width = MathHelper.ceil((double)((double)(System.currentTimeMillis() / 250L) % 18.0 / 1.0));
                this.blit(startPoint.x + 44, startPoint.y + 28, 103, 163, width, 4);
            }
        }}));
        widgets.add((Object)new SlotWidget(startPoint.x + 1, startPoint.y + 1, Arrays.asList(new ItemStack((ItemConvertible)Items.BLAZE_POWDER)), false, true, true));
        widgets.add((Object)new SlotWidget(startPoint.x + 63, startPoint.y + 1, recipeDisplay.getInput().get(0), false, true, true){

            @Override
            protected List<String> getExtraToolTips(ItemStack stack) {
                return Collections.singletonList(Formatting.YELLOW.toString() + I18n.translate((String)"category.rei.brewing.input", (Object[])new Object[0]));
            }
        });
        widgets.add((Object)new SlotWidget(startPoint.x + 40, startPoint.y + 1, recipeDisplay.getInput().get(1), false, true, true){

            @Override
            protected List<String> getExtraToolTips(ItemStack stack) {
                return Collections.singletonList(Formatting.YELLOW.toString() + I18n.translate((String)"category.rei.brewing.reactant", (Object[])new Object[0]));
            }
        });
        widgets.add((Object)new SlotWidget(startPoint.x + 40, startPoint.y + 35, recipeDisplay.getOutput(0), false, true, true){

            @Override
            protected List<String> getExtraToolTips(ItemStack stack) {
                return Collections.singletonList(Formatting.YELLOW.toString() + I18n.translate((String)"category.rei.brewing.result", (Object[])new Object[0]));
            }
        });
        widgets.add((Object)new SlotWidget(startPoint.x + 63, startPoint.y + 42, recipeDisplay.getOutput(1), false, true, true){

            @Override
            protected List<String> getExtraToolTips(ItemStack stack) {
                return Collections.singletonList(Formatting.YELLOW.toString() + I18n.translate((String)"category.rei.brewing.result", (Object[])new Object[0]));
            }
        });
        widgets.add((Object)new SlotWidget(startPoint.x + 86, startPoint.y + 35, recipeDisplay.getOutput(2), false, true, true){

            @Override
            protected List<String> getExtraToolTips(ItemStack stack) {
                return Collections.singletonList(Formatting.YELLOW.toString() + I18n.translate((String)"category.rei.brewing.result", (Object[])new Object[0]));
            }
        });
        return widgets;
    }

    @Override
    public boolean checkTags() {
        return true;
    }
}

