/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.recipe.Ingredient;
import net.minecraft.recipe.Recipe;
import net.minecraft.util.Identifier;

public class DefaultBrewingDisplay
implements RecipeDisplay {
    private ItemStack input;
    private ItemStack output;
    private Ingredient reactant;

    public DefaultBrewingDisplay(ItemStack input, Ingredient reactant, ItemStack output) {
        this.input = input;
        this.reactant = reactant;
        this.output = output;
    }

    public Optional<Recipe> getRecipe() {
        return Optional.empty();
    }

    @Override
    public List<List<ItemStack>> getInput() {
        return Lists.newArrayList((Object[])new List[]{Collections.singletonList(this.input), Arrays.asList(this.reactant.getStackArray())});
    }

    @Override
    public List<ItemStack> getOutput() {
        return Collections.singletonList(this.output);
    }

    @Override
    public Identifier getRecipeCategory() {
        return DefaultPlugin.BREWING;
    }

    public List<ItemStack> getOutput(int slot) {
        int i;
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        for (i = 0; i < slot * 2; ++i) {
            stack.add(new ItemStack((ItemConvertible)Blocks.AIR));
        }
        for (i = 0; i < 6 - slot * 2; ++i) {
            stack.addAll(this.getOutput());
        }
        return stack;
    }

    @Override
    public List<List<ItemStack>> getRequiredItems() {
        return Collections.singletonList(Collections.singletonList(ItemStack.EMPTY));
    }
}

