/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.Renderable;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import me.shedaniel.rei.gui.widget.SlotWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.plugin.DefaultCampfireDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.block.Blocks;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.render.GuiLighting;
import net.minecraft.client.resource.language.I18n;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.MathHelper;

public class DefaultCampfireCategory
implements RecipeCategory<DefaultCampfireDisplay> {
    @Override
    public Identifier getIdentifier() {
        return DefaultPlugin.CAMPFIRE;
    }

    @Override
    public Renderer getIcon() {
        return Renderable.fromItemStack(new ItemStack((ItemConvertible)Blocks.CAMPFIRE));
    }

    @Override
    public String getCategoryName() {
        return I18n.translate((String)"category.rei.campfire", (Object[])new Object[0]);
    }

    @Override
    public List<Widget> setupDisplay(final Supplier<DefaultCampfireDisplay> recipeDisplaySupplier, final Rectangle bounds) {
        final Point startPoint = new Point((int)bounds.getCenterX() - 41, (int)bounds.getCenterY() - 27);
        LinkedList<Widget> widgets = new LinkedList<Widget>(Arrays.asList(new 1[]{new RecipeBaseWidget(bounds){

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                super.render(mouseX, mouseY, delta);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiLighting.disable();
                MinecraftClient.getInstance().getTextureManager().bindTexture(DefaultPlugin.getDisplayTexture());
                this.blit(startPoint.x, startPoint.y, 0, 167, 82, 54);
                int height = MathHelper.ceil((double)((double)(System.currentTimeMillis() / 250L) % 14.0 / 1.0));
                this.blit(startPoint.x + 2, startPoint.y + 31 + (14 - height), 82, 77 + (14 - height), 14, height);
                int width = MathHelper.ceil((double)((double)(System.currentTimeMillis() / 250L) % 24.0 / 1.0));
                this.blit(startPoint.x + 24, startPoint.y + 18, 82, 91, width, 17);
                String text = I18n.translate((String)"category.rei.campfire.time", (Object[])new Object[]{MathHelper.floor((double)((double)((DefaultCampfireDisplay)recipeDisplaySupplier.get()).getCookTime() / 20.0))});
                int length = MinecraftClient.getInstance().textRenderer.getStringWidth(text);
                MinecraftClient.getInstance().textRenderer.draw(text, (float)(bounds.x + bounds.width - length - 5), (float)(startPoint.y + 54 - 8), 0x404040);
            }
        }}));
        widgets.add((Object)new SlotWidget(startPoint.x + 1, startPoint.y + 11, recipeDisplaySupplier.get().getInput().get(0), true, true, true));
        widgets.add((Object)new SlotWidget(startPoint.x + 61, startPoint.y + 19, recipeDisplaySupplier.get().getOutput(), false, true, true));
        return widgets;
    }
}

