/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.item.ItemStack;
import net.minecraft.recipe.CampfireCookingRecipe;
import net.minecraft.recipe.Ingredient;
import net.minecraft.util.DefaultedList;
import net.minecraft.util.Identifier;

public class DefaultCampfireDisplay
implements RecipeDisplay<CampfireCookingRecipe> {
    private List<List<ItemStack>> inputs;
    private List<ItemStack> output;
    private int cookTime;
    private CampfireCookingRecipe display;

    public DefaultCampfireDisplay(CampfireCookingRecipe recipe) {
        this((DefaultedList<Ingredient>)recipe.getPreviewInputs(), recipe.getOutput(), recipe.getCookTime());
        this.display = recipe;
    }

    public DefaultCampfireDisplay(DefaultedList<Ingredient> ingredients, ItemStack output, int cookTime) {
        this.inputs = ingredients.stream().map(i -> Arrays.asList(i.getStackArray())).collect(Collectors.toList());
        this.output = Collections.singletonList(output);
        this.cookTime = cookTime;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    @Override
    public Optional<CampfireCookingRecipe> getRecipe() {
        return Optional.ofNullable(this.display);
    }

    @Override
    public List<List<ItemStack>> getInput() {
        return this.inputs;
    }

    @Override
    public List<ItemStack> getOutput() {
        return this.output;
    }

    @Override
    public Identifier getRecipeCategory() {
        return DefaultPlugin.CAMPFIRE;
    }

    @Override
    public List<List<ItemStack>> getRequiredItems() {
        return this.getInput();
    }
}

