/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.rei.api.DisplaySettings;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.Renderable;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.gui.renderables.RecipeRenderer;
import me.shedaniel.rei.gui.widget.RecipeBaseWidget;
import me.shedaniel.rei.gui.widget.SlotWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.plugin.DefaultCompostingDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.block.Blocks;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.render.GuiLighting;
import net.minecraft.client.resource.language.I18n;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.MathHelper;

public class DefaultCompostingCategory
implements RecipeCategory<DefaultCompostingDisplay> {
    @Override
    public Identifier getIdentifier() {
        return DefaultPlugin.COMPOSTING;
    }

    @Override
    public Renderer getIcon() {
        return Renderable.fromItemStack(new ItemStack((ItemConvertible)Blocks.COMPOSTER));
    }

    @Override
    public String getCategoryName() {
        return I18n.translate((String)"category.rei.composting", (Object[])new Object[0]);
    }

    @Override
    public RecipeRenderer getSimpleRenderer(final DefaultCompostingDisplay recipe) {
        return new RecipeRenderer(){

            @Override
            public int getHeight() {
                MinecraftClient.getInstance().textRenderer.getClass();
                return 10 + 9;
            }

            @Override
            public void render(int x, int y, double mouseX, double mouseY, float delta) {
                MinecraftClient.getInstance().textRenderer.draw(I18n.translate((String)"text.rei.composting.page", (Object[])new Object[]{recipe.getPage() + 1}), (float)(x + 5), (float)(y + 6), -1);
            }
        };
    }

    @Override
    public List<Widget> setupDisplay(final Supplier<DefaultCompostingDisplay> recipeDisplaySupplier, Rectangle bounds) {
        ArrayList widgets = Lists.newArrayList();
        final Point startingPoint = new Point(bounds.x + bounds.width - 55, bounds.y + 110);
        widgets.add(new RecipeBaseWidget(bounds){

            @Override
            public void render(int mouseX, int mouseY, float partialTicks) {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiLighting.disable();
                MinecraftClient.getInstance().getTextureManager().bindTexture(DefaultPlugin.getDisplayTexture());
                this.blit(startingPoint.x, startingPoint.y, 28, 221, 55, 26);
            }
        });
        LinkedList<ItemConvertible> stacks = new LinkedList<ItemConvertible>(recipeDisplaySupplier.get().getItemsByOrder());
        int i = 0;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 8; ++x) {
                widgets.add(new SlotWidget((int)bounds.getCenterX() - 72 + x * 18, bounds.y + y * 18, stacks.size() > i ? Arrays.asList(((ItemConvertible)stacks.get(i)).asItem().getStackForRender()) : Lists.newArrayList(), true, true, true){

                    @Override
                    protected List<String> getExtraToolTips(ItemStack stack) {
                        List[] thing = new List[]{null};
                        ((DefaultCompostingDisplay)recipeDisplaySupplier.get()).getInputMap().forEach((itemProvider, aFloat) -> {
                            if (itemProvider.asItem().equals(stack.getItem())) {
                                thing[0] = Arrays.asList(I18n.translate((String)"text.rei.composting.chance", (Object[])new Object[]{MathHelper.fastFloor((double)(aFloat.floatValue() * 100.0f))}));
                            }
                        });
                        if (thing[0] != null) {
                            return thing[0];
                        }
                        return super.getExtraToolTips(stack);
                    }
                });
                ++i;
            }
        }
        widgets.add(new SlotWidget(startingPoint.x + 34, startingPoint.y + 5, recipeDisplaySupplier.get().getOutput(), false, true, true));
        return widgets;
    }

    @Override
    public DisplaySettings getDisplaySettings() {
        return new DisplaySettings(){

            @Override
            public int getDisplayHeight(RecipeCategory iRecipeCategory) {
                return 140;
            }

            public int getDisplayWidth(RecipeCategory iRecipeCategory, RecipeDisplay display) {
                return 150;
            }

            @Override
            public int getMaximumRecipePerPage(RecipeCategory iRecipeCategory) {
                return -1;
            }

            @Override
            public int getFixedRecipesPerPage() {
                return 1;
            }
        };
    }
}

