/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.item.ItemStack;
import net.minecraft.recipe.Recipe;
import net.minecraft.util.Identifier;

public class DefaultCompostingDisplay
implements RecipeDisplay {
    private List<ItemConvertible> order;
    private List<ItemConvertible> allItems;
    private Map<ItemConvertible, Float> inputMap;
    private ItemStack[] output;
    private int page;

    public DefaultCompostingDisplay(int page, List<ItemConvertible> order, Map<ItemConvertible, Float> inputMap, List<ItemConvertible> allItems, ItemStack[] output) {
        this.page = page;
        this.order = order;
        this.inputMap = inputMap;
        this.output = output;
        this.allItems = allItems;
    }

    public int getPage() {
        return this.page;
    }

    public Optional<Recipe> getRecipe() {
        return Optional.empty();
    }

    @Override
    public List<List<ItemStack>> getInput() {
        ArrayList<List<ItemStack>> lists = new ArrayList<List<ItemStack>>();
        this.allItems.stream().forEachOrdered(itemProvider -> lists.add(Arrays.asList(itemProvider.asItem().getStackForRender())));
        return lists;
    }

    public Map<ItemConvertible, Float> getInputMap() {
        return this.inputMap;
    }

    @Override
    public List<ItemStack> getOutput() {
        return Arrays.asList(this.output);
    }

    @Override
    public Identifier getRecipeCategory() {
        return DefaultPlugin.COMPOSTING;
    }

    @Override
    public List<List<ItemStack>> getRequiredItems() {
        return Arrays.asList(new LinkedList(this.allItems.stream().map(ItemConvertible::asItem).map(Item::getStackForRender).collect(Collectors.toList())));
    }

    public List<ItemConvertible> getItemsByOrder() {
        return this.order;
    }
}

