/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.plugin.DefaultCraftingDisplay;
import net.minecraft.item.ItemStack;
import net.minecraft.recipe.Recipe;
import net.minecraft.recipe.ShapedRecipe;

public class DefaultShapedDisplay
implements DefaultCraftingDisplay<ShapedRecipe> {
    private ShapedRecipe display;
    private List<List<ItemStack>> input;
    private List<ItemStack> output;

    public DefaultShapedDisplay(ShapedRecipe recipe) {
        this.display = recipe;
        this.input = recipe.getPreviewInputs().stream().map(i -> Arrays.asList(i.getStackArray())).collect(Collectors.toList());
        this.output = Collections.singletonList(recipe.getOutput());
    }

    @Override
    public Optional<Recipe> getRecipe() {
        return Optional.ofNullable(this.display);
    }

    @Override
    public List<List<ItemStack>> getInput() {
        return this.input;
    }

    @Override
    public List<ItemStack> getOutput() {
        return this.output;
    }

    @Override
    public List<List<ItemStack>> getRequiredItems() {
        return this.input;
    }

    @Override
    public int getHeight() {
        return this.display.getHeight();
    }

    @Override
    public int getWidth() {
        return this.display.getWidth();
    }
}

