/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.plugin.DefaultCraftingDisplay;
import net.minecraft.item.ItemStack;
import net.minecraft.recipe.ShapelessRecipe;

public class DefaultShapelessDisplay
implements DefaultCraftingDisplay {
    private ShapelessRecipe display;
    private List<List<ItemStack>> input;
    private List<ItemStack> output;

    public DefaultShapelessDisplay(ShapelessRecipe recipe) {
        this.display = recipe;
        this.input = recipe.getPreviewInputs().stream().map(i -> Arrays.asList(i.getStackArray())).collect(Collectors.toList());
        this.output = Collections.singletonList(recipe.getOutput());
    }

    @Override
    public Optional<ShapelessRecipe> getRecipe() {
        return Optional.ofNullable(this.display);
    }

    @Override
    public List<List<ItemStack>> getInput() {
        return this.input;
    }

    @Override
    public List<ItemStack> getOutput() {
        return this.output;
    }

    @Override
    public List<List<ItemStack>> getRequiredItems() {
        return this.input;
    }

    @Override
    public int getWidth() {
        if (this.display.getPreviewInputs().size() > 4) {
            return 3;
        }
        return 2;
    }

    @Override
    public int getHeight() {
        if (this.display.getPreviewInputs().size() > 4) {
            return 3;
        }
        return 2;
    }
}

