/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.plugin.DefaultPlugin;
import net.minecraft.block.entity.FurnaceBlockEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.recipe.SmokingRecipe;
import net.minecraft.util.Identifier;

public class DefaultSmokingDisplay
implements RecipeDisplay<SmokingRecipe> {
    private SmokingRecipe display;
    private List<List<ItemStack>> input;
    private List<ItemStack> output;

    public DefaultSmokingDisplay(SmokingRecipe recipe) {
        this.display = recipe;
        this.input = recipe.getPreviewInputs().stream().map(i -> Arrays.asList(i.getStackArray())).collect(Collectors.toList());
        this.input.add(FurnaceBlockEntity.createFuelTimeMap().keySet().stream().map(Item::getStackForRender).collect(Collectors.toList()));
        this.output = Collections.singletonList(recipe.getOutput());
    }

    @Override
    public Optional<SmokingRecipe> getRecipe() {
        return Optional.ofNullable(this.display);
    }

    @Override
    public List<List<ItemStack>> getInput() {
        return this.input;
    }

    public List<ItemStack> getFuel() {
        return this.input.get(1);
    }

    @Override
    public List<ItemStack> getOutput() {
        return this.output;
    }

    @Override
    public Identifier getRecipeCategory() {
        return DefaultPlugin.SMOKING;
    }

    @Override
    public List<List<ItemStack>> getRequiredItems() {
        return this.input;
    }
}

