/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.api;

import java.awt.*;
import java.util.List;
import net.minecraft.class_437;

public interface BaseBoundsHandler extends DisplayHelper.DisplayBoundsHandler<class_437> {
    /**
     * Gets the exclusion zones by the screen class
     *
     * @param currentScreenClass the current screen class
     * @param isOnRightSide      whether the user has set the overlay to the right
     * @return the list of exclusion zones
     */
    default List<Rectangle> getCurrentExclusionZones(Class<? extends class_437> currentScreenClass, boolean isOnRightSide) {
        return getCurrentExclusionZones(currentScreenClass, isOnRightSide, true);
    }
    
    List<Rectangle> getCurrentExclusionZones(Class<? extends class_437> currentScreenClass, boolean isOnRightSide, boolean sort);
    
    /**
     * Register an exclusion zone
     *
     * @param screenClass the screen
     * @param supplier    the exclusion zone supplier
     */
    void registerExclusionZones(Class<? extends class_437> screenClass, ExclusionZoneSupplier supplier);
    
    public static interface ExclusionZoneSupplier {
        /**
         * Gets the current exclusion zones
         *
         * @param isOnRightSide whether the user has set the overlay to the right
         * @return the list of exclusion zones
         */
        List<Rectangle> apply(boolean isOnRightSide);
    }
}
