/*
 * Roughly Enough Items by Danielshe.
 * Licensed under the MIT License.
 */

package me.shedaniel.rei.client;

import com.google.common.collect.Lists;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;
import net.minecraft.class_1269;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import java.awt.*;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public class BaseBoundsHandlerImpl implements BaseBoundsHandler {
    
    private static final Function<? super Rectangle, Long> RECTANGLE_LONG_FUNCTION = r -> r.x + 1000l * r.y + 1000000l * r.width + 1000000000l * r.height;
    private static final Comparator<class_3545<class_3545<Class<?>, Float>, ExclusionZoneSupplier>> LIST_PAIR_COMPARATOR;
    private static final Comparator<? super Rectangle> RECTANGLE_COMPARER = Comparator.comparingLong(RECTANGLE_LONG_FUNCTION::apply);
    
    static {
        Comparator<class_3545<class_3545<Class<?>, Float>, ExclusionZoneSupplier>> comparator = Comparator.comparingDouble(value -> value.method_15442().method_15441());
        LIST_PAIR_COMPARATOR = comparator.reversed();
    }
    
    private long lastArea = -1;
    private List<class_3545<class_3545<Class<?>, Float>, ExclusionZoneSupplier>> list = Lists.newArrayList();
    
    @Override
    public Class getBaseSupportedClass() {
        return class_437.class;
    }
    
    @Override
    public Rectangle getLeftBounds(class_437 screen) {
        return new Rectangle();
    }
    
    @Override
    public Rectangle getRightBounds(class_437 screen) {
        return new Rectangle();
    }
    
    @Override
    public float getPriority() {
        return -5f;
    }
    
    @Override
    public class_1269 isInZone(boolean isOnRightSide, double mouseX, double mouseY) {
        for (Rectangle zone : getCurrentExclusionZones(class_310.method_1551().field_1755.getClass(), isOnRightSide, false))
            if (zone.contains(mouseX, mouseY))
                return class_1269.field_5814;
        return class_1269.field_5811;
    }
    
    @Override
    public boolean shouldRecalculateArea(boolean isOnRightSide, Rectangle rectangle) {
        long current = getStringFromCurrent(isOnRightSide);
        if (lastArea == current)
            return false;
        lastArea = current;
        return true;
    }
    
    private DisplayHelper.DisplayBoundsHandler getHandler() {
        return RoughlyEnoughItemsCore.getDisplayHelper().getResponsibleBoundsHandler(class_310.method_1551().field_1755.getClass());
    }
    
    private long getStringFromCurrent(boolean isOnRightSide) {
        return getLongFromAreas(isOnRightSide ? getHandler().getRightBounds(class_310.method_1551().field_1755) : getHandler().getLeftBounds(class_310.method_1551().field_1755), getCurrentExclusionZones(class_310.method_1551().field_1755.getClass(), isOnRightSide, false));
    }
    
    @Override
    public class_1269 canItemSlotWidgetFit(boolean isOnRightSide, int left, int top, class_437 screen, Rectangle fullBounds) {
        for (Rectangle currentExclusionZone : getCurrentExclusionZones(class_310.method_1551().field_1755.getClass(), isOnRightSide, false))
            if (left + 18 >= currentExclusionZone.x && top + 18 >= currentExclusionZone.y && left <= currentExclusionZone.x + currentExclusionZone.width && top <= currentExclusionZone.y + currentExclusionZone.height)
                return class_1269.field_5814;
        return class_1269.field_5811;
    }
    
    @Override
    public List<Rectangle> getCurrentExclusionZones(Class<? extends class_437> currentScreenClass, boolean isOnRightSide, boolean sort) {
        List<Rectangle> rectangles = Lists.newArrayList();
        for (class_3545<class_3545<Class<?>, Float>, ExclusionZoneSupplier> pair : list) {
            if (pair.method_15442().method_15442().isAssignableFrom(currentScreenClass))
                rectangles.addAll(pair.method_15441().apply(isOnRightSide));
        }
        if (sort)
            rectangles.sort(RECTANGLE_COMPARER);
        return rectangles;
    }
    
    @Override
    public void registerExclusionZones(Class<? extends class_437> screenClass, ExclusionZoneSupplier supplier) {
        list.add(new class_3545<>(new class_3545<>(screenClass, 0f), supplier));
    }
    
    public long getLongFromAreas(Rectangle rectangle, List<Rectangle> exclusionZones) {
        long a = RECTANGLE_LONG_FUNCTION.apply(rectangle);
        for (Rectangle exclusionZone : exclusionZones)
            a -= RECTANGLE_LONG_FUNCTION.apply(exclusionZone);
        return a;
    }
    
}
